package org.lockss.laaws.rs.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.v3.oas.annotations.media.Schema;
import org.springframework.core.io.Resource;
import org.springframework.validation.annotation.Validated;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;

/**
 * ArtifactsBody
 */
@Validated



public class ArtifactsBody   {
  @JsonProperty("artifactProps")
  private String artifactProps = null;

  @JsonProperty("payload")
  private Resource payload = null;

  @JsonProperty("httpResponseHeader")
  private String httpResponseHeader = null;

  public ArtifactsBody artifactProps(String artifactProps) {
    this.artifactProps = artifactProps;
    return this;
  }

  /**
   * Artifact properties (JSON)
   * @return artifactProps
   **/
  @Schema(required = true, description = "Artifact properties (JSON)")
      @NotNull

    public String getArtifactProps() {
    return artifactProps;
  }

  public void setArtifactProps(String artifactProps) {
    this.artifactProps = artifactProps;
  }

  public ArtifactsBody payload(Resource payload) {
    this.payload = payload;
    return this;
  }

  /**
   * Artifact payload data
   * @return payload
   **/
  @Schema(required = true, description = "Artifact payload data")
      @NotNull

    @Valid
    public Resource getPayload() {
    return payload;
  }

  public void setPayload(Resource payload) {
    this.payload = payload;
  }

  public ArtifactsBody httpResponseHeader(String httpResponseHeader) {
    this.httpResponseHeader = httpResponseHeader;
    return this;
  }

  /**
   * HTTP response status and headers (optional)
   * @return httpResponseHeader
   **/
  @Schema(description = "HTTP response status and headers (optional)")
  
    public String getHttpResponseHeader() {
    return httpResponseHeader;
  }

  public void setHttpResponseHeader(String httpResponseHeader) {
    this.httpResponseHeader = httpResponseHeader;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ArtifactsBody artifactsBody = (ArtifactsBody) o;
    return Objects.equals(this.artifactProps, artifactsBody.artifactProps) &&
        Objects.equals(this.payload, artifactsBody.payload) &&
        Objects.equals(this.httpResponseHeader, artifactsBody.httpResponseHeader);
  }

  @Override
  public int hashCode() {
    return Objects.hash(artifactProps, payload, httpResponseHeader);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ArtifactsBody {\n");
    
    sb.append("    artifactProps: ").append(toIndentedString(artifactProps)).append("\n");
    sb.append("    payload: ").append(toIndentedString(payload)).append("\n");
    sb.append("    httpResponseHeader: ").append(toIndentedString(httpResponseHeader)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
