/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.index.solr;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.lucene.util.Version;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.request.ConfigSetAdminRequest;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.response.ConfigSetAdminResponse;
import org.apache.solr.client.solrj.response.CoreAdminResponse;
import org.apache.solr.client.solrj.response.SolrResponseBase;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.lockss.laaws.rs.index.solr.SolrArtifactIndexAdmin;
import org.lockss.laaws.rs.io.index.solr.SolrResponseErrorException;
import org.lockss.log.L4JLogger;

/*
 * Exception performing whole class analysis ignored.
 */
public class SolrArtifactIndexAdmin {
    private static final L4JLogger log = L4JLogger.getLogger();
    public static final String DEFAULT_SOLRCORE_NAME = "lockss";
    public static final int LATEST_LOCKSS_CONFIGSET_VERSION = 3;
    public static final Version TARGET_LUCENE_VERSION = Version.fromBits((int)7, (int)2, (int)1);
    public static final String LOCKSS_CONFIGSET_VERSION_KEY = "lockss-configset-version";
    public static final String KEY_ACTION = "action";
    public static final String KEY_CORE = "core";
    public static final String KEY_LOCAL = "local";
    public static final String KEY_COLLECTION = "collection";
    public static final String KEY_CLOUD = "cloud";
    public static final String KEY_ZKHOST = "zkHost";

    private static Map<String, Object> getFieldModifier(String modifier, Object value) {
        HashMap<String, Object> fieldModifier = new HashMap<String, Object>();
        fieldModifier.put(modifier, value);
        return fieldModifier;
    }

    public static boolean coreExists(SolrClient solrClient, String coreName) throws IOException, SolrServerException {
        CoreAdminResponse response = CoreAdminRequest.getStatus((String)coreName, (SolrClient)solrClient);
        return response.getCoreStatus(coreName).size() > 0;
    }

    public List<String> getAvailableConfigSets(SolrClient solrClient) throws IOException, SolrServerException {
        ConfigSetAdminRequest.List listReq = new ConfigSetAdminRequest.List();
        return ((ConfigSetAdminResponse.List)listReq.process(solrClient)).getConfigSets();
    }

    static <T extends SolrResponseBase> T handleSolrResponse(T solrResponse, String errorMessage) throws SolrResponseErrorException {
        log.debug2("solrResponse = {}", solrResponse);
        NamedList solrResponseResponse = solrResponse.getResponse();
        if (solrResponse.getStatus() == 0 && solrResponseResponse.get("error") == null && solrResponseResponse.get("errors") == null) {
            log.debug2("solrResponse indicates success");
            return solrResponse;
        }
        log.trace("solrResponse indicates failure");
        SolrResponseErrorException snzse = new SolrResponseErrorException(errorMessage, solrResponse);
        log.error((Object)snzse);
        throw snzse;
    }

    private static void exit(AdminExitCode exitCode) {
        System.exit(exitCode.getStatus());
    }

    public static void runAction(CommandLine cmd) throws IOException, SolrServerException, SolrResponseErrorException {
        if (cmd.hasOption("local") && cmd.hasOption("cloud")) {
            throw new IllegalArgumentException("Both --local and --cloud may not be specified at the same time");
        }
        if (cmd.hasOption("local")) {
            Path solrHome = Paths.get(cmd.getOptionValue("local"), new String[0]);
            String coreName = cmd.hasOption("core") ? cmd.getOptionValue("core") : "lockss";
            switch (cmd.getOptionValue("action")) {
                case "create": {
                    try {
                        LocalSolrCoreAdmin.createCore((Path)Paths.get(cmd.getOptionValue("local"), new String[0]), (String)coreName);
                        break;
                    }
                    catch (SolrException e) {
                        if (e.getMessage().indexOf("already exists") != -1) {
                            log.info("Core already exists");
                            break;
                        }
                        throw e;
                    }
                }
                case "update": {
                    LocalSolrCoreAdmin admin1 = LocalSolrCoreAdmin.fromSolrHomeAndCoreName((Path)solrHome, (String)coreName);
                    admin1.update();
                    break;
                }
                case "verify": {
                    LocalSolrCoreAdmin admin2 = LocalSolrCoreAdmin.fromSolrHomeAndCoreName((Path)solrHome, (String)coreName);
                    if (admin2 != null) {
                        if (!admin2.isUpdateInProgress() && admin2.isReindexInProgress()) {
                            log.error("Detected interrupted update!");
                            SolrArtifactIndexAdmin.exit((AdminExitCode)AdminExitCode.UPDATE_FAILURE);
                        }
                        if (admin2.isUpdateInProgress() && admin2.isReindexInProgress()) {
                            log.info("Update in-progress in another thread or JVM");
                            SolrArtifactIndexAdmin.exit((AdminExitCode)AdminExitCode.UPDATE_INPROGRESS);
                        }
                        if (admin2.isUpdateAvailable()) {
                            log.info("Update available");
                            SolrArtifactIndexAdmin.exit((AdminExitCode)AdminExitCode.UPDATE_NEEDED);
                        }
                        System.exit(0);
                        break;
                    }
                    log.error("Core not found!");
                    SolrArtifactIndexAdmin.exit((AdminExitCode)AdminExitCode.MISSING_CORE);
                    break;
                }
                case "force-reindex": {
                    try {
                        LocalSolrCoreAdmin admin3 = LocalSolrCoreAdmin.fromSolrHomeAndCoreName((Path)solrHome, (String)coreName);
                        admin3.reindexLatest();
                    }
                    catch (Exception e) {
                        log.error("Caught exception while forcing a full reindex to latest artifact schema", (Throwable)e);
                    }
                    break;
                }
                default: {
                    log.error("Unknown action to perform [action: {}]", (Object)cmd.getOptionValue("action"));
                    throw new IllegalArgumentException("Unknown action");
                }
            }
        } else if (cmd.hasOption("cloud")) {
            String solrUrl = cmd.getOptionValue("cloud");
            try (CloudSolrClient cloudClient = new CloudSolrClient.Builder().withSolrUrl(solrUrl).withZkHost(cmd.getOptionValue("zkHost")).build();){
                String collection = cmd.hasOption("collection") ? cmd.getOptionValue("collection") : "lockss";
                cloudClient.setDefaultCollection(collection);
                SolrCloudCollectionAdmin updater = SolrCloudCollectionAdmin.fromCloudSolrClient((CloudSolrClient)cloudClient);
                updater.update();
            }
        } else {
            throw new IllegalArgumentException("--local or --cloud must be specified");
        }
    }

    public static void main(String[] args) throws ParseException, IOException, SolrResponseErrorException, SolrServerException {
        Options options = new Options();
        options.addOption(null, "action", true, "Action to perform (create, update, force-reindex or verify)");
        options.addOption(null, "core", true, "Name of Solr core");
        options.addOption(null, "local", true, "Path to Solr home base directory");
        options.addOption(null, "collection", true, "Name of Solr Cloud collection");
        options.addOption(null, "cloud", true, "Solr Cloud REST endpoint");
        options.addOption(null, "zkHost", true, "ZooKeeper REST endpoint used by Solr Cloud cluster");
        try {
            CommandLine cmd = new PosixParser().parse(options, args);
            SolrArtifactIndexAdmin.runAction((CommandLine)cmd);
            SolrArtifactIndexAdmin.exit((AdminExitCode)AdminExitCode.OK);
        }
        catch (Exception e) {
            log.error("Exception caught", (Throwable)e);
            SolrArtifactIndexAdmin.exit((AdminExitCode)AdminExitCode.ERROR);
        }
    }

    static /* synthetic */ L4JLogger access$000() {
        return log;
    }

    static /* synthetic */ Map access$100(String x0, Object x1) {
        return SolrArtifactIndexAdmin.getFieldModifier((String)x0, (Object)x1);
    }
}

