/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.index.solr;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.index.IndexUpgrader;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.ConfigSetAdminRequest;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.request.schema.FieldTypeDefinition;
import org.apache.solr.client.solrj.request.schema.SchemaRequest;
import org.apache.solr.client.solrj.response.ConfigSetAdminResponse;
import org.apache.solr.client.solrj.response.CoreAdminResponse;
import org.apache.solr.client.solrj.response.SolrResponseBase;
import org.apache.solr.client.solrj.response.schema.SchemaResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrXmlConfig;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.json.JSONObject;
import org.lockss.laaws.rs.index.solr.CoreConfigRequest;
import org.lockss.laaws.rs.index.solr.CoreConfigResponse;
import org.lockss.laaws.rs.io.index.solr.SolrQueryArtifactIterator;
import org.lockss.laaws.rs.io.index.solr.SolrResponseErrorException;
import org.lockss.laaws.rs.model.Artifact;
import org.lockss.log.L4JLogger;
import org.lockss.util.io.FileUtil;

public class SolrArtifactIndexAdmin {
    private static final L4JLogger log = L4JLogger.getLogger();
    public static final String DEFAULT_SOLRCORE_NAME = "lockss";
    public static final int LATEST_LOCKSS_CONFIGSET_VERSION = 3;
    public static final Version TARGET_LUCENE_VERSION = Version.fromBits((int)7, (int)2, (int)1);
    public static final String LOCKSS_CONFIGSET_VERSION_KEY = "lockss-configset-version";
    public static final String KEY_ENDPOINT = "endpoint";
    public static final String KEY_ACTION = "action";
    public static final String KEY_CORE = "core";
    public static final String KEY_LOCAL = "local";
    public static final String KEY_COLLECTION = "collection";
    public static final String KEY_CLOUD = "cloud";
    public static final String KEY_ZKHOST = "zkHost";

    private static Map<String, Object> getFieldModifier(String modifier, Object value) {
        HashMap<String, Object> fieldModifier = new HashMap<String, Object>();
        fieldModifier.put(modifier, value);
        return fieldModifier;
    }

    public static boolean coreExists(SolrClient solrClient, String coreName) throws IOException, SolrServerException {
        CoreAdminResponse response = CoreAdminRequest.getStatus((String)coreName, (SolrClient)solrClient);
        return response.getCoreStatus(coreName).size() > 0;
    }

    public List<String> getAvailableConfigSets(SolrClient solrClient) throws IOException, SolrServerException {
        ConfigSetAdminRequest.List listReq = new ConfigSetAdminRequest.List();
        return ((ConfigSetAdminResponse.List)listReq.process(solrClient)).getConfigSets();
    }

    static <T extends SolrResponseBase> T handleSolrResponse(T solrResponse, String errorMessage) throws SolrResponseErrorException {
        log.debug2("solrResponse = {}", solrResponse);
        NamedList solrResponseResponse = solrResponse.getResponse();
        if (solrResponse.getStatus() == 0 && solrResponseResponse.get("error") == null && solrResponseResponse.get("errors") == null) {
            log.debug2("solrResponse indicates success");
            return solrResponse;
        }
        log.trace("solrResponse indicates failure");
        SolrResponseErrorException snzse = new SolrResponseErrorException(errorMessage, solrResponse);
        log.error((Object)snzse);
        throw snzse;
    }

    private static void exit(AdminExitCode exitCode) {
        System.exit(exitCode.getStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void runAction(CommandLine cmd) throws IOException, SolrServerException, SolrResponseErrorException {
        if (cmd.hasOption(KEY_LOCAL) && cmd.hasOption(KEY_CLOUD)) {
            throw new IllegalArgumentException("Both --local and --cloud may not be specified at the same time");
        }
        if (cmd.hasOption(KEY_LOCAL)) {
            Path solrHome = Paths.get(cmd.getOptionValue(KEY_LOCAL), new String[0]);
            String coreName = cmd.hasOption(KEY_CORE) ? cmd.getOptionValue(KEY_CORE) : DEFAULT_SOLRCORE_NAME;
            switch (cmd.getOptionValue(KEY_ACTION)) {
                case "create": {
                    try {
                        LocalSolrCoreAdmin.createCore(Paths.get(cmd.getOptionValue(KEY_LOCAL), new String[0]), coreName);
                        return;
                    }
                    catch (SolrException e) {
                        if (e.getMessage().indexOf("already exists") == -1) throw e;
                        log.info("Core already exists");
                        return;
                    }
                }
                case "update": {
                    LocalSolrCoreAdmin admin1 = LocalSolrCoreAdmin.fromSolrHomeAndCoreName(solrHome, coreName);
                    admin1.update();
                    return;
                }
                case "verify": {
                    LocalSolrCoreAdmin admin2 = LocalSolrCoreAdmin.fromSolrHomeAndCoreName(solrHome, coreName);
                    if (admin2 != null) {
                        boolean updateInProgress = admin2.isUpdateInProgress();
                        boolean reindexInProgress = admin2.isReindexInProgress();
                        if (!updateInProgress && reindexInProgress) {
                            log.error("Detected interrupted update!");
                            SolrArtifactIndexAdmin.exit(AdminExitCode.UPDATE_FAILURE);
                        }
                        if (updateInProgress && reindexInProgress) {
                            log.info("Update in-progress in another thread or JVM");
                            SolrArtifactIndexAdmin.exit(AdminExitCode.UPDATE_INPROGRESS);
                        }
                        if (admin2.isUpdateAvailable()) {
                            log.info("Update available");
                            SolrArtifactIndexAdmin.exit(AdminExitCode.UPDATE_NEEDED);
                        }
                        System.exit(0);
                        return;
                    }
                    log.error("Core not found!");
                    SolrArtifactIndexAdmin.exit(AdminExitCode.MISSING_CORE);
                    return;
                }
                case "force-reindex": {
                    try {
                        LocalSolrCoreAdmin admin3 = LocalSolrCoreAdmin.fromSolrHomeAndCoreName(solrHome, coreName);
                        admin3.reindexLatest();
                        return;
                    }
                    catch (Exception e) {
                        log.error("Caught exception while forcing a full reindex to latest artifact schema", (Throwable)e);
                    }
                    return;
                }
                case "upgrade-lucene-index": {
                    LocalSolrCoreAdmin admin4 = LocalSolrCoreAdmin.fromSolrHomeAndCoreName(solrHome, coreName);
                    admin4.upgradeLuceneIndex();
                    System.exit(0);
                    return;
                }
                case "update-lockss-configset": {
                    try {
                        LocalSolrCoreAdmin admin5 = LocalSolrCoreAdmin.fromSolrHomeAndCoreName(solrHome, coreName);
                        if (admin5.isLockssConfigSetUpdateAvailable()) {
                            int targetVersion = admin5.getLockssConfigSetVersion() + 1;
                            admin5.retireConfigSet();
                            admin5.installLockssConfigSetVersion(targetVersion);
                            System.exit(0);
                            return;
                        }
                        System.exit(1);
                        return;
                    }
                    catch (Exception e) {
                        log.error("Could not install LOCKSS configuration set", (Throwable)e);
                        System.exit(2);
                    }
                    return;
                }
                default: {
                    log.error("Unknown action to perform [action: {}]", (Object)cmd.getOptionValue(KEY_ACTION));
                    throw new IllegalArgumentException("Unknown action");
                }
            }
        }
        if (cmd.hasOption(KEY_ENDPOINT)) {
            try (HttpSolrClient solrClient = new HttpSolrClient.Builder().withBaseSolrUrl(cmd.getOptionValue(KEY_ENDPOINT)).build();){
                switch (cmd.getOptionValue(KEY_ACTION)) {
                    case "apply-lockss-configset-changes": {
                        CoreConfigRequest.Overlay req = new CoreConfigRequest.Overlay();
                        CoreConfigResponse.Overlay res = (CoreConfigResponse.Overlay)req.process((SolrClient)solrClient);
                        int targetVersion = res.getLockssConfigSetVersion();
                        SolrArtifactIndexReindex.reindexArtifactsForVersion((SolrClient)solrClient, targetVersion);
                        return;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown action: " + cmd.getOptionValue(KEY_ACTION));
                    }
                }
            }
        }
        if (!cmd.hasOption(KEY_CLOUD)) throw new IllegalArgumentException("--local, --endpoint, or --cloud must be specified");
        String solrUrl = cmd.getOptionValue(KEY_CLOUD);
        try (CloudSolrClient cloudClient = new CloudSolrClient.Builder().withSolrUrl(solrUrl).withZkHost(cmd.getOptionValue(KEY_ZKHOST)).build();){
            String collection = cmd.hasOption(KEY_COLLECTION) ? cmd.getOptionValue(KEY_COLLECTION) : DEFAULT_SOLRCORE_NAME;
            cloudClient.setDefaultCollection(collection);
            SolrCloudCollectionAdmin updater = SolrCloudCollectionAdmin.fromCloudSolrClient(cloudClient);
            updater.update();
            return;
        }
    }

    public static void main(String[] args) throws ParseException, IOException, SolrResponseErrorException, SolrServerException {
        Options options = new Options();
        options.addOption(null, KEY_ACTION, true, "Action to perform (create, update, force-reindex or verify)");
        options.addOption(null, KEY_CORE, true, "Name of Solr core");
        options.addOption(null, KEY_LOCAL, true, "Path to Solr home base directory");
        options.addOption(null, KEY_ENDPOINT, true, "Solr REST endpoint");
        options.addOption(null, KEY_COLLECTION, true, "Name of Solr Cloud collection");
        options.addOption(null, KEY_CLOUD, true, "Solr Cloud REST endpoint");
        options.addOption(null, KEY_ZKHOST, true, "ZooKeeper REST endpoint used by Solr Cloud cluster");
        try {
            CommandLine cmd = new PosixParser().parse(options, args);
            SolrArtifactIndexAdmin.runAction(cmd);
            SolrArtifactIndexAdmin.exit(AdminExitCode.OK);
        }
        catch (Exception e) {
            log.error("Exception caught", (Throwable)e);
            SolrArtifactIndexAdmin.exit(AdminExitCode.ERROR);
        }
    }

    private static enum AdminExitCode {
        OK(0),
        MISSING_CORE(1),
        UPDATE_NEEDED(2),
        UPDATE_INPROGRESS(4),
        UPDATE_FAILURE(8),
        ERROR(Integer.MAX_VALUE);

        int status;

        private AdminExitCode(int status) {
            this.status = status;
        }

        public int getStatus() {
            return this.status;
        }
    }

    public static class SolrCloudCollectionAdmin {
        CloudSolrClient cloudClient;
        public static final String SOLR_CONFIGSET_PATH = "target/test-classes/solr";
        public static final String SOLR_CONFIGSET_NAME = "testConfig";

        public SolrCloudCollectionAdmin(CloudSolrClient cloudClient) {
            this.cloudClient = cloudClient;
        }

        public static SolrCloudCollectionAdmin fromCloudSolrClient(CloudSolrClient cloudClient) {
            return new SolrCloudCollectionAdmin(cloudClient);
        }

        public static CloudSolrClient createSolrCloudClient(String solrUrl, String zkHost) {
            CloudSolrClient.Builder builder = new CloudSolrClient.Builder();
            builder.withSolrUrl(solrUrl);
            builder.withZkHost(zkHost);
            return builder.build();
        }

        public void update() {
            try {
                this.uploadConfigSet();
            }
            catch (IOException | SolrServerException | SolrResponseErrorException e) {
                log.error("Caught exception while attempting to upgrade Solr Cloud collection [collection: " + this.cloudClient.getDefaultCollection() + "]");
            }
        }

        public static int getLockssConfigSetVersion() {
            return 0;
        }

        public void uploadConfigSet() throws IOException, SolrResponseErrorException, SolrServerException {
            int lockssConfigSetVersion = SolrCloudCollectionAdmin.getLockssConfigSetVersion();
            int targetVersion = 3;
            log.trace("lockssConfigSetVersion = {}", (Object)lockssConfigSetVersion);
            log.trace("targetVersion = {}", (Object)targetVersion);
            for (int version = lockssConfigSetVersion; version < targetVersion; ++version) {
                this.installConfigSetVersion(version + 1);
                SolrArtifactIndexReindex.reindexArtifactsForVersion((SolrClient)this.cloudClient, version + 1);
                lockssConfigSetVersion = version + 1;
            }
        }

        private void installConfigSetVersion(int i) throws IOException {
            try (SolrZkClient zkClient = new SolrZkClient(this.cloudClient.getZkHost(), 10);){
                zkClient.upConfig(Paths.get(SOLR_CONFIGSET_PATH, new String[0]), SOLR_CONFIGSET_NAME);
            }
        }

        public void applySchemaUpdates() {
            try {
                new ArtifactIndexSchemaUpdater((SolrClient)this.cloudClient).updateSchema(3);
            }
            catch (IOException | SolrServerException | SolrResponseErrorException e) {
                e.printStackTrace();
            }
        }

        public boolean collectionExists(String collectionName) throws IOException, SolrServerException {
            List collections = CollectionAdminRequest.listCollections((SolrClient)this.cloudClient);
            return collections.contains(collectionName);
        }
    }

    public static class LocalSolrCoreAdmin {
        public static final String CONFIGOVERLAY_FILE = "configoverlay.json";
        public static final String CONFIGOVERLAY_USERPROPS_KEY = "userProps";
        protected String solrCoreName;
        protected Path solrHome;
        protected Path instanceDir;
        protected Path configDirPath;
        protected Path dataDir;
        protected Path indexDir;
        protected String sharedConfigSetName;
        protected Path sharedConfigSetBaseDir;
        protected int lockssConfigSetVersion;
        public static final String UPGRADE_LOCK_FILE = "upgrade.lock";
        public static final String REINDEX_LOCK_FILE = "reindex.lock";
        private static final String lockssSolrSchemaVersionFieldName = "solrSchemaLockssVersion";

        public LocalSolrCoreAdmin(String name, Path solrHome, Path instanceDir, Path configDirPath, Path dataDir, Path indexDir, String sharedConfigSetName, Path sharedConfigSetBaseDir, int version) {
            this.solrCoreName = name;
            this.solrHome = solrHome;
            this.instanceDir = instanceDir;
            this.configDirPath = configDirPath;
            this.dataDir = dataDir;
            this.indexDir = indexDir;
            this.sharedConfigSetName = sharedConfigSetName;
            this.sharedConfigSetBaseDir = sharedConfigSetBaseDir;
            this.lockssConfigSetVersion = version;
        }

        public void create() throws IOException, SolrServerException {
            if (this.configDirPath == null) {
                throw new IllegalStateException("Cannot create Solr core with a null configuration directory path");
            }
            FileUtil.ensureDirExists((File)this.configDirPath.toFile());
            this.installLockssConfigSetVersion(this.lockssConfigSetVersion);
            try (EmbeddedSolrServer solrClient = new EmbeddedSolrServer(this.solrHome, this.solrCoreName);){
                CoreAdminRequest.Create req = new CoreAdminRequest.Create();
                req.setCoreName(this.solrCoreName);
                req.setInstanceDir(this.solrHome.relativize(this.instanceDir).toString());
                req.process((SolrClient)solrClient);
            }
        }

        public static void createCore(Path solrHome, String solrCoreName) throws IOException, SolrServerException {
            LocalSolrCoreAdmin.createCore(solrHome, solrCoreName, 3);
        }

        public static void createCore(Path solrHome, String solrCoreName, int lockssConfigSetVersion) throws IOException, SolrServerException {
            if (lockssConfigSetVersion <= 0) {
                throw new IllegalArgumentException("Illegal LOCKSS configuration set version [version: " + lockssConfigSetVersion + "]");
            }
            Path instanceDir = solrHome.resolve(String.format("lockss/cores/%s", solrCoreName));
            LocalSolrCoreAdmin admin = new LocalSolrCoreAdmin(solrCoreName, solrHome, instanceDir, instanceDir.resolve("conf"), instanceDir.resolve("data"), instanceDir.resolve("data/index"), null, null, lockssConfigSetVersion);
            admin.create();
        }

        public void update() throws IOException, SolrResponseErrorException, SolrServerException {
            File reindexLockFile = this.indexDir.resolve(UPGRADE_LOCK_FILE).toFile();
            try (FileChannel channel = new RandomAccessFile(reindexLockFile, "rw").getChannel();){
                try (FileLock lock = channel.tryLock();){
                    this.upgradeLuceneIndex();
                    this.updateConfigSet();
                }
                catch (OverlappingFileLockException e) {
                    log.info("An update is already in progress");
                }
            }
        }

        public boolean isUpdateAvailable() throws IOException {
            return this.isLuceneIndexUpgradeAvailable() || this.isLockssConfigSetUpdateAvailable();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isCoreExists() {
            CoreContainer container = CoreContainer.createAndLoad((Path)this.solrHome);
            try {
                boolean result = container.getAllCoreNames().contains(this.solrCoreName);
                log.trace("isExists(core = {}) = {}", (Object)this.getCoreName(), (Object)result);
                boolean bl = result;
                return bl;
            }
            finally {
                container.shutdown();
            }
        }

        public boolean isLuceneIndexUpgradeAvailable() throws IOException {
            boolean result;
            SegmentInfos segInfos = this.getSegmentInfos();
            log.trace("segInfos.size() = {}", (Object)segInfos.size());
            if (segInfos.size() > 0) {
                Version minSegVersion = segInfos.getMinSegmentLuceneVersion();
                log.trace("minSegVersion = {}, targetVersion = {}", (Object)minSegVersion, (Object)TARGET_LUCENE_VERSION);
                result = !minSegVersion.onOrAfter(TARGET_LUCENE_VERSION);
            } else {
                log.trace("Index contains no segments");
                result = false;
            }
            log.trace("isLuceneIndexUpgradeAvailable(core = {}) = {}", (Object)this.getCoreName(), (Object)result);
            return result;
        }

        public boolean isLockssConfigSetUpdateAvailable() throws IOException {
            boolean result = this.getLockssConfigSetVersion() < 3;
            log.trace("isLockssConfigSetUpdateAvailable(core = {}) = {}", (Object)this.getCoreName(), (Object)result);
            return result;
        }

        public boolean isUpdateInProgress() throws IOException {
            boolean result;
            File lockfile = this.indexDir.resolve(UPGRADE_LOCK_FILE).toFile();
            log.trace("lockfile = {}", (Object)lockfile);
            try (FileChannel channel = new RandomAccessFile(lockfile, "rw").getChannel();){
                try (FileLock lock = channel.tryLock();){
                    result = false;
                }
                catch (OverlappingFileLockException e) {
                    result = true;
                }
            }
            log.trace("isUpdateInProgress(core = {}) = {}", (Object)this.getCoreName(), (Object)result);
            return result;
        }

        public boolean isReindexInProgress() throws IOException {
            File reindexLockFile = this.indexDir.resolve(REINDEX_LOCK_FILE).toFile();
            return reindexLockFile.exists();
        }

        @Deprecated
        public void applySchemaUpdates() {
            log.debug("Applying schema updates through SolrJ");
            try (EmbeddedSolrServer solrClient = new EmbeddedSolrServer(this.solrHome, this.solrCoreName);){
                new ArtifactIndexSchemaUpdater((SolrClient)solrClient).updateSchema(3);
            }
            catch (IOException | SolrServerException | SolrResponseErrorException e) {
                e.printStackTrace();
            }
        }

        public void upgradeLuceneIndex() throws IOException {
            if (this.isLuceneIndexUpgradeAvailable()) {
                new IndexUpgrader((Directory)FSDirectory.open((Path)this.indexDir)).upgrade();
            }
        }

        public SegmentInfos getSegmentInfos() throws IOException {
            if (this.indexDir == null) {
                throw new IllegalStateException("Null index directory path");
            }
            return SegmentInfos.readLatestCommit((Directory)FSDirectory.open((Path)this.indexDir));
        }

        public void updateConfigSet() throws IOException, SolrResponseErrorException, SolrServerException {
            if (!this.isLockssConfigSetUpdateAvailable()) {
                log.trace("Already at latest; nothing to do");
                return;
            }
            int targetVersion = 3;
            if (this.lockssConfigSetVersion <= 0) {
                this.lockssConfigSetVersion = this.getLockssConfigSetVersion();
            }
            log.trace("currentVersion = {}", (Object)this.lockssConfigSetVersion);
            log.trace("targetVersion = {}", (Object)targetVersion);
            this.retireConfigSet();
            for (int version = this.lockssConfigSetVersion; version < targetVersion; ++version) {
                block20: {
                    FileUtils.deleteDirectory((File)this.configDirPath.toFile());
                    this.installLockssConfigSetVersion(version + 1);
                    try (EmbeddedSolrServer solrClient = new EmbeddedSolrServer(this.solrHome, this.solrCoreName);){
                        File reindexLockFile = this.indexDir.resolve(REINDEX_LOCK_FILE).toFile();
                        if (!reindexLockFile.exists()) {
                            FileUtils.touch((File)reindexLockFile);
                            SolrArtifactIndexReindex.reindexArtifactsForVersion((SolrClient)solrClient, version + 1);
                            FileUtils.forceDelete((File)reindexLockFile);
                            break block20;
                        }
                        log.trace("Reindex is already in progress");
                        return;
                    }
                    catch (SolrServerException | SolrResponseErrorException e) {
                        log.error("Caught an exception while attempting to reindex artifacts for target version [version: {}]: {}", (Object)(version + 1), (Object)e);
                        throw e;
                    }
                }
                ++this.lockssConfigSetVersion;
            }
        }

        public int getLockssConfigSetVersion() throws IOException {
            try {
                return LocalSolrCoreAdmin.getLockssConfigSetVersionFromOverlay(this.configDirPath);
            }
            catch (FileNotFoundException e) {
                return LocalSolrCoreAdmin.getLockssConfigSetVersionFromField(this.solrHome, this.solrCoreName);
            }
        }

        public static int getLockssConfigSetVersionFromOverlay(Path configDir) throws IOException {
            if (Objects.isNull(configDir)) {
                throw new IllegalArgumentException("Null configuration set path");
            }
            File configOverlayPath = configDir.resolve(CONFIGOVERLAY_FILE).toFile();
            try (FileInputStream input = new FileInputStream(configOverlayPath);){
                JSONObject userProps;
                JSONObject json = new JSONObject(IOUtils.toString((InputStream)input, (String)"UTF-8"));
                if (json.has(CONFIGOVERLAY_USERPROPS_KEY) && (userProps = json.getJSONObject(CONFIGOVERLAY_USERPROPS_KEY)).has(SolrArtifactIndexAdmin.LOCKSS_CONFIGSET_VERSION_KEY)) {
                    int n = userProps.getInt(SolrArtifactIndexAdmin.LOCKSS_CONFIGSET_VERSION_KEY);
                    return n;
                }
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Deprecated
        public static int getLockssConfigSetVersionFromField(Path solrHome, String coreName) {
            CoreContainer cc = CoreContainer.createAndLoad((Path)solrHome);
            try (SolrCore core = cc.getCore(coreName);){
                if (core == null) {
                    int n = -1;
                    return n;
                }
                IndexSchema schema = core.getLatestSchema();
                if (schema.hasExplicitField(lockssSolrSchemaVersionFieldName)) {
                    int n = Integer.valueOf(schema.getField(lockssSolrSchemaVersionFieldName).getDefaultValue());
                    return n;
                }
                if (!LocalSolrCoreAdmin.hasSolrField(schema, SolrArtifactIndexAdmin.KEY_COLLECTION, "string")) return -1;
                if (!LocalSolrCoreAdmin.hasSolrField(schema, "auid", "string")) return -1;
                if (!LocalSolrCoreAdmin.hasSolrField(schema, "uri", "string")) return -1;
                if (!LocalSolrCoreAdmin.hasSolrField(schema, "committed", "boolean")) return -1;
                if (!LocalSolrCoreAdmin.hasSolrField(schema, "storageUrl", "string")) return -1;
                if (!LocalSolrCoreAdmin.hasSolrField(schema, "contentLength", "plong")) return -1;
                if (!LocalSolrCoreAdmin.hasSolrField(schema, "contentDigest", "string")) return -1;
                if (!LocalSolrCoreAdmin.hasSolrField(schema, "version", "pint")) return -1;
                int n = 1;
                return n;
            }
            finally {
                cc.shutdown();
            }
        }

        public static boolean hasSolrField(IndexSchema schema, String fieldName, String expectedType) {
            FieldType actualFieldType = schema.getField(fieldName).getType();
            return actualFieldType.getTypeName().equalsIgnoreCase(expectedType);
        }

        public static int getLockssConfigSetVersionFromSolrCore(SolrCore core) {
            Map userProps = core.getSolrConfig().getOverlay().getUserProps();
            log.trace("userProps = {}", (Object)userProps);
            return userProps.containsKey(SolrArtifactIndexAdmin.LOCKSS_CONFIGSET_VERSION_KEY) ? Integer.parseInt(String.valueOf(userProps.get(SolrArtifactIndexAdmin.LOCKSS_CONFIGSET_VERSION_KEY))) : 0;
        }

        public void retireConfigSet() throws IOException {
            LocalSolrCoreAdmin.retirePath(this.configDirPath);
        }

        public static void retirePath(Path targetPath) throws IOException {
            String timestamp = DateTimeFormatter.BASIC_ISO_DATE.format(LocalDateTime.now());
            String suffix = String.format("saved.%s", timestamp);
            LocalSolrCoreAdmin.addSuffix(targetPath, suffix);
        }

        public static void addSuffix(Path targetPath, String suffix) throws IOException {
            String baseFileName = String.format("%s.%s", targetPath.getFileName(), suffix);
            Path dstTargetPath = targetPath.getParent().resolve(baseFileName);
            int step = LocalSolrCoreAdmin.getLatestFileNameSuffix(dstTargetPath) + 1;
            if (step > 0) {
                String targetFileName = String.format("%s.%d", baseFileName, step);
                dstTargetPath = targetPath.getParent().resolve(targetFileName);
            }
            FileUtils.moveDirectory((File)targetPath.toFile(), (File)dstTargetPath.toFile());
        }

        public static synchronized int getLatestFileNameSuffix(Path targetPath) {
            OptionalInt optMaxStep;
            String baseFileName = String.format("%s.", targetPath.getFileName());
            String[] allSiblingNames = targetPath.getParent().toFile().list();
            if (allSiblingNames != null && (optMaxStep = Arrays.stream(allSiblingNames).filter(name -> name.startsWith(baseFileName)).map(name -> name.substring(baseFileName.length())).filter(StringUtils::isNumeric).mapToInt(Integer::parseInt).max()).isPresent()) {
                return optMaxStep.getAsInt();
            }
            return targetPath.toFile().exists() ? 0 : -1;
        }

        public void installLockssConfigSetVersion(int version) throws IOException {
            log.trace("Installing LOCKSS configuration set version {} to {}", (Object)version, (Object)this.configDirPath.toAbsolutePath());
            String fileListResource = String.format("/solr/configsets/lockss/v%d/filelist.txt", version);
            InputStream input = this.getClass().getResourceAsStream(fileListResource);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(input));){
                String resourceName;
                while ((resourceName = reader.readLine()) != null) {
                    URL srcUrl = this.getClass().getResource(String.format("/solr/configsets/lockss/v%d/conf/%s", version, resourceName));
                    File dstFile = this.configDirPath.resolve(resourceName).toFile();
                    FileUtils.copyURLToFile((URL)srcUrl, (File)dstFile);
                }
            }
        }

        public boolean coreUsesCommonConfigSet() {
            return this.sharedConfigSetName != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static LocalSolrCoreAdmin fromSolrHomeAndCoreName(Path solrHome, String coreName) throws IOException {
            log.trace("solrHome = {}", (Object)solrHome.toAbsolutePath());
            log.trace("coreName = {}", (Object)coreName);
            CoreContainer container = CoreContainer.createAndLoad((Path)solrHome);
            try {
                Map failureMap = container.getCoreInitFailures();
                if (failureMap.containsKey(coreName)) {
                    throw new IOException("Failed to load core [coreName: " + coreName + "]", ((CoreContainer.CoreLoadFailure)failureMap.get((Object)coreName)).exception);
                }
                try (SolrCore core = container.getCore(coreName);){
                    if (core != null) {
                        LocalSolrCoreAdmin localSolrCoreAdmin = LocalSolrCoreAdmin.fromSolrCore(core);
                        return localSolrCoreAdmin;
                    }
                }
            }
            finally {
                container.shutdown();
            }
            return null;
        }

        public static LocalSolrCoreAdmin fromSolrCore(SolrCore core) {
            if (core == null) {
                throw new IllegalArgumentException("Null Solr core");
            }
            log.trace("getConfigName() = {}", (Object)core.getCoreDescriptor().getConfigName());
            log.trace("getConfigSet() = {}", (Object)core.getCoreDescriptor().getConfigSet());
            return new LocalSolrCoreAdmin(core.getName(), Paths.get(core.getCoreContainer().getSolrHome(), new String[0]), core.getResourceLoader().getInstancePath(), Paths.get(core.getResourceLoader().getConfigDir(), new String[0]), Paths.get(core.getDataDir(), new String[0]), Paths.get(core.getIndexDir(), new String[0]), core.getCoreDescriptor().getConfigSet(), core.getCoreDescriptor().getConfigSet() == null ? core.getCoreContainer().getNodeConfig().getConfigSetBaseDirectory() : SolrXmlConfig.fromSolrHome((Path)Paths.get(core.getCoreContainer().getSolrHome(), new String[0])).getConfigSetBaseDirectory().resolve(core.getCoreDescriptor().getConfigSet()), LocalSolrCoreAdmin.getLockssConfigSetVersionFromSolrCore(core));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LocalSolrCoreAdmin coreAdmin = (LocalSolrCoreAdmin)o;
            return this.lockssConfigSetVersion == coreAdmin.lockssConfigSetVersion && this.solrCoreName.equals(coreAdmin.solrCoreName) && this.solrHome.equals(coreAdmin.solrHome) && this.instanceDir.equals(coreAdmin.instanceDir) && this.configDirPath.equals(coreAdmin.configDirPath) && this.dataDir.equals(coreAdmin.dataDir) && this.indexDir.equals(coreAdmin.indexDir) && Objects.equals(this.sharedConfigSetName, coreAdmin.sharedConfigSetName) && Objects.equals(this.sharedConfigSetBaseDir, coreAdmin.sharedConfigSetBaseDir);
        }

        public int hashCode() {
            return Objects.hash(this.solrCoreName, this.solrHome, this.instanceDir, this.configDirPath, this.dataDir, this.indexDir, this.sharedConfigSetName, this.sharedConfigSetBaseDir, this.lockssConfigSetVersion);
        }

        public String getCoreName() {
            return this.solrCoreName;
        }

        public void reindexLatest() throws IOException, SolrResponseErrorException, SolrServerException {
            try (EmbeddedSolrServer solrClient = new EmbeddedSolrServer(this.solrHome, this.solrCoreName);){
                File reindexLockFile = this.indexDir.resolve(REINDEX_LOCK_FILE).toFile();
                if (reindexLockFile.createNewFile()) {
                    SolrArtifactIndexReindex.reindexArtifactsForVersion((SolrClient)solrClient, 3);
                    FileUtils.forceDelete((File)reindexLockFile);
                } else {
                    log.trace("Reindex is already in progress");
                }
            }
        }
    }

    @Deprecated
    public static class ArtifactIndexSchemaUpdater {
        private static final String lockssSolrSchemaVersionFieldName = "solrSchemaLockssVersion";
        private static final String solrIntegerType = "pint";
        private static final String solrLongType = "plong";
        private Map<String, Map<String, Object>> solrSchemaFields = null;
        private SolrClient solrClient;

        public ArtifactIndexSchemaUpdater(SolrClient client) {
            this.solrClient = client;
        }

        private void updateSchema(int targetSchemaVersion) throws SolrResponseErrorException, SolrServerException, IOException {
            log.debug2("targetSchemaVersion = " + targetSchemaVersion);
            this.solrSchemaFields = this.getSolrSchemaFields();
            int existingSchemaVersion = this.getExistingLockssSchemaVersion();
            log.trace("existingSchemaVersion = {}", (Object)existingSchemaVersion);
            if (targetSchemaVersion < existingSchemaVersion) {
                throw new RuntimeException("Existing LOCKSS Solr schema version is " + existingSchemaVersion + ", which is higher than the target schema version " + targetSchemaVersion + " for this service. Possibly caused by service downgrade.");
            }
            if (targetSchemaVersion > existingSchemaVersion) {
                log.trace("Schema needs to be updated from version {} to version {}", (Object)existingSchemaVersion, (Object)targetSchemaVersion);
                int lastUpdatedVersion = this.updateSchema(existingSchemaVersion, targetSchemaVersion);
                log.trace("lastRecordedVersion = {}", (Object)lastUpdatedVersion);
                log.info("Schema has been updated to LOCKSS version {}", (Object)lastUpdatedVersion);
            } else {
                log.info("Schema is up-to-date at LOCKSS version {}", (Object)existingSchemaVersion);
            }
            log.debug2("Done.");
        }

        private Map<String, Map<String, Object>> getSolrSchemaFields() throws SolrResponseErrorException, SolrServerException, IOException {
            log.debug2("Invoked");
            SchemaResponse.FieldsResponse fieldsResponse = null;
            try {
                fieldsResponse = (SchemaResponse.FieldsResponse)SolrArtifactIndexAdmin.handleSolrResponse((SolrResponseBase)new SchemaRequest.Fields().process(this.solrClient), "Problem getting Solr schema fields");
            }
            catch (IOException | SolrServerException e) {
                String errorMessage = "Exception caught getting Solr schema fields";
                log.error(errorMessage, e);
                throw e;
            }
            HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
            for (Map field : fieldsResponse.getFields()) {
                String fieldName = (String)field.get("name");
                log.trace("fieldName = {}", (Object)fieldName);
                result.put(fieldName, field);
            }
            log.debug2("result = {}", result);
            return result;
        }

        private int getExistingLockssSchemaVersion() {
            log.debug2("Invoked");
            int result = this.getSolrSchemaLockssVersionFromField();
            log.trace("result = {}", (Object)result);
            if (result == 0 && this.hasSolrField(SolrArtifactIndexAdmin.KEY_COLLECTION, "string") && this.hasSolrField("auid", "string") && this.hasSolrField("uri", "string") && this.hasSolrField("committed", "boolean") && this.hasSolrField("storageUrl", "string") && this.hasSolrField("contentLength", solrLongType) && this.hasSolrField("contentDigest", "string") && this.hasSolrField("version", solrIntegerType) && this.hasSolrField("collectionDate", "long")) {
                result = 1;
            }
            log.debug2("result = {}", (Object)result);
            return result;
        }

        private boolean hasSolrField(String fieldName, String fieldType) {
            Map<String, Object> field = this.solrSchemaFields.get(fieldName);
            return field != null && field.equals(this.getNewFieldAttributes(fieldName, fieldType, null));
        }

        private int getSolrSchemaLockssVersionFromField() {
            log.debug2("Invoked");
            int result = 0;
            Map<String, Object> field = this.solrSchemaFields.get(lockssSolrSchemaVersionFieldName);
            if (field != null) {
                result = Integer.valueOf((String)field.get("default"));
            }
            log.debug2("result = {}", (Object)result);
            return result;
        }

        private int updateSchema(int existingVersion, int finalVersion) throws SolrResponseErrorException, SolrServerException, IOException {
            log.debug2("existingVersion = {}", (Object)existingVersion);
            log.debug2("finalVersion = {}", (Object)finalVersion);
            int lastUpdatedVersion = existingVersion;
            for (int from = existingVersion; from < finalVersion; ++from) {
                log.trace("Updating from version {}...", (Object)from);
                this.updateSchemaToVersion(from + 1);
                lastUpdatedVersion = from + 1;
                log.debug("Solr Schema updated to LOCKSS version {}", (Object)lastUpdatedVersion);
                this.updateSolrLockssSchemaVersionField(lastUpdatedVersion);
            }
            log.debug2("lastRecordedVersion = {}", (Object)lastUpdatedVersion);
            return lastUpdatedVersion;
        }

        private void updateSchemaToVersion(int targetVersion) throws SolrResponseErrorException, SolrServerException, IOException {
            log.debug2("targetVersion = {}", (Object)targetVersion);
            try {
                switch (targetVersion) {
                    case 1: {
                        this.updateSchemaFrom0To1();
                        break;
                    }
                    case 2: {
                        this.updateSchemaFrom1To2();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Non-existent method to update the schema to version " + targetVersion);
                    }
                }
            }
            catch (IOException | SolrServerException e) {
                String errorMessage = "Exception caught updating Solr schema to LOCKSS version " + targetVersion;
                log.error(errorMessage, e);
                throw e;
            }
        }

        private void createSolrField(SolrClient solr, String fieldName, String fieldType) throws SolrResponseErrorException, IOException, SolrServerException {
            this.createSolrField(solr, fieldName, fieldType, null);
        }

        private void createSolrField(SolrClient solr, String fieldName, String fieldType, Map<String, Object> fieldAttributes) throws SolrResponseErrorException, IOException, SolrServerException {
            Map<String, Object> newFieldAttributes = this.getNewFieldAttributes(fieldName, fieldType, fieldAttributes);
            if (!this.hasSolrField(fieldName, fieldType)) {
                log.debug("Adding field to Solr schema: {}", newFieldAttributes);
                SchemaRequest.AddField addFieldReq = new SchemaRequest.AddField(newFieldAttributes);
                SolrArtifactIndexAdmin.handleSolrResponse((SolrResponseBase)addFieldReq.process(solr), "Problem adding field to Solr schema");
            } else {
                log.debug("Field already exists in Solr schema: {}; skipping field addition", newFieldAttributes);
            }
        }

        private Map<String, Object> getNewFieldAttributes(String fieldName, String fieldType, Map<String, Object> fieldAttributes) {
            LinkedHashMap<String, Object> newFieldAttributes = new LinkedHashMap<String, Object>();
            newFieldAttributes.put("name", fieldName);
            newFieldAttributes.put("type", fieldType);
            newFieldAttributes.put("indexed", true);
            newFieldAttributes.put("stored", true);
            newFieldAttributes.put("multiValued", false);
            newFieldAttributes.put("required", true);
            if (fieldAttributes != null) {
                newFieldAttributes.putAll(fieldAttributes);
            }
            return newFieldAttributes;
        }

        private SchemaResponse.UpdateResponse createSolrFieldType(Map<String, Object> fieldTypeAttributes) throws IOException, SolrServerException {
            FieldTypeDefinition ftd = new FieldTypeDefinition();
            ftd.setAttributes(fieldTypeAttributes);
            SchemaRequest.AddFieldType req = new SchemaRequest.AddFieldType(ftd);
            return (SchemaResponse.UpdateResponse)req.process(this.solrClient);
        }

        private void updateSchemaFrom0To1() throws SolrServerException, IOException, SolrResponseErrorException {
            HashMap<String, Object> ftd = new HashMap<String, Object>();
            ftd.put("name", "long");
            ftd.put("class", "solr.TrieLongField");
            ftd.put("docValues", "true");
            ftd.put("precisionStep", 0);
            ftd.put("positionIncrementGap", 0);
            if (!this.hasSolrFieldType(ftd)) {
                this.createSolrFieldType(ftd);
            }
            this.createSolrField(this.solrClient, SolrArtifactIndexAdmin.KEY_COLLECTION, "string");
            this.createSolrField(this.solrClient, "auid", "string");
            this.createSolrField(this.solrClient, "uri", "string");
            this.createSolrField(this.solrClient, "committed", "boolean");
            this.createSolrField(this.solrClient, "storageUrl", "string");
            this.createSolrField(this.solrClient, "contentLength", solrLongType);
            this.createSolrField(this.solrClient, "contentDigest", "string");
            this.createSolrField(this.solrClient, "version", solrIntegerType);
            this.createSolrField(this.solrClient, "collectionDate", "long");
        }

        private boolean hasSolrFieldType(Map<String, Object> fieldTypeAttributes) throws IOException, SolrServerException {
            SchemaRequest.FieldTypes req = new SchemaRequest.FieldTypes();
            SchemaResponse.FieldTypesResponse res = (SchemaResponse.FieldTypesResponse)req.process(this.solrClient);
            return res.getFieldTypes().stream().anyMatch(ft -> ft.equals(fieldTypeAttributes));
        }

        private void updateSchemaFrom1To2() throws SolrResponseErrorException, SolrServerException, IOException {
            log.debug2("Invoked");
            SchemaRequest.ReplaceField req = new SchemaRequest.ReplaceField(this.getNewFieldAttributes("collectionDate", solrLongType, null));
            req.process(this.solrClient);
            this.createSolrField(this.solrClient, "sortUri", "string");
            try {
                SolrQuery q = new SolrQuery().setQuery("*:*");
                for (Artifact artifact : IteratorUtils.asIterable((Iterator)new SolrQueryArtifactIterator(this.solrClient, q))) {
                    SolrInputDocument document = new SolrInputDocument(new String[0]);
                    document.addField("id", (Object)artifact.getId());
                    document.addField("sortUri", (Object)SolrArtifactIndexAdmin.getFieldModifier("set", artifact.getSortUri()));
                    document.addField("collectionDate", (Object)SolrArtifactIndexAdmin.getFieldModifier("set", artifact.getCollectionDate()));
                    log.trace("document = {}", (Object)document);
                    SolrArtifactIndexAdmin.handleSolrResponse(this.solrClient.add(document), "Problem adding document '" + document + "' to Solr");
                }
                SolrArtifactIndexAdmin.handleSolrResponse(this.solrClient.commit(), "Problem committing changes to Solr");
            }
            catch (IOException | SolrServerException e) {
                String errorMessage = "Exception caught updating Solr schema to LOCKSS version 2";
                log.error(errorMessage, e);
                throw e;
            }
            log.debug2("Done");
        }

        public void updateSolrLockssSchemaVersionField(int schemaVersion) throws SolrResponseErrorException, SolrServerException, IOException {
            log.debug2("schemaVersion = {}", (Object)schemaVersion);
            LinkedHashMap<String, Object> newFieldAttributes = new LinkedHashMap<String, Object>();
            newFieldAttributes.put("name", lockssSolrSchemaVersionFieldName);
            newFieldAttributes.put("type", solrIntegerType);
            newFieldAttributes.put("indexed", true);
            newFieldAttributes.put("stored", true);
            newFieldAttributes.put("multiValued", false);
            newFieldAttributes.put("required", false);
            newFieldAttributes.put("default", String.valueOf(schemaVersion));
            try {
                Map<String, Object> field = this.solrSchemaFields.get(lockssSolrSchemaVersionFieldName);
                log.trace("field = {}", field);
                if (field != null) {
                    log.trace("Replacing field '{}' in Solr schema", field);
                    SolrArtifactIndexAdmin.handleSolrResponse((SolrResponseBase)new SchemaRequest.ReplaceField(newFieldAttributes).process(this.solrClient), "Problem replacing field '" + field + "' in the Solr schema");
                } else {
                    log.trace("Adding field to Solr schema: {}", newFieldAttributes);
                    SolrArtifactIndexAdmin.handleSolrResponse((SolrResponseBase)new SchemaRequest.AddField(newFieldAttributes).process(this.solrClient), "Problem adding field '" + field + "' in the Solr schema");
                }
            }
            catch (IOException | SolrServerException e) {
                String errorMessage = "Exception caught updating Solr schema LOCKSS version field to " + schemaVersion;
                log.error(errorMessage, e);
                throw e;
            }
            log.debug2("Done");
        }
    }

    public static class SolrArtifactIndexReindex {
        public static void reindexArtifactsForVersion(SolrClient solrClient, int targetVersion) throws SolrServerException, SolrResponseErrorException, IOException {
            log.trace("targetVersion = {}", (Object)targetVersion);
            try {
                switch (targetVersion) {
                    case 2: {
                        SolrArtifactIndexReindex.reindexArtifactsFrom1To2(solrClient);
                        break;
                    }
                    case 3: {
                        SolrArtifactIndexReindex.reindexArtifactsFrom2To3(solrClient);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("No post configset installation tasks for version: " + targetVersion);
                    }
                }
            }
            catch (IOException | SolrServerException | SolrResponseErrorException e) {
                log.error("Caught exception while performing post configset installation tasks [targetVersion: {}]", (Object)targetVersion);
                throw e;
            }
        }

        public static void reindexArtifactsFrom1To2(SolrClient solrClient) throws IOException, SolrServerException, SolrResponseErrorException {
            try {
                SolrQuery q = new SolrQuery().setQuery("*:*");
                for (Artifact artifact : IteratorUtils.asIterable((Iterator)new SolrQueryArtifactIterator(solrClient, q))) {
                    SolrInputDocument document = new SolrInputDocument(new String[0]);
                    document.addField("id", (Object)artifact.getId());
                    document.addField("sortUri", (Object)SolrArtifactIndexAdmin.getFieldModifier("set", artifact.getSortUri()));
                    document.addField("collectionDate", (Object)SolrArtifactIndexAdmin.getFieldModifier("set", artifact.getCollectionDate()));
                    log.trace("document = {}", (Object)document);
                    SolrArtifactIndexAdmin.handleSolrResponse(solrClient.add(document), "Problem adding artifact '" + document + "' to Solr");
                }
                SolrArtifactIndexAdmin.handleSolrResponse(solrClient.commit(), "Problem committing changes to Solr");
            }
            catch (IOException | SolrServerException | SolrResponseErrorException e) {
                String errorMessage = "Caught exception while performing post configset installation tasks for version 2";
                log.error(errorMessage, e);
                throw e;
            }
        }

        private static void reindexArtifactsFrom2To3(SolrClient solrClient) throws IOException, SolrServerException, SolrResponseErrorException {
            SolrArtifactIndexReindex.reindexAllArtifacts(solrClient);
        }

        public static void reindexAllArtifacts(SolrClient solrClient) throws SolrServerException, SolrResponseErrorException, IOException {
            try {
                SolrQuery q = new SolrQuery().setQuery("*:*");
                for (Artifact artifact : IteratorUtils.asIterable((Iterator)new SolrQueryArtifactIterator(solrClient, q))) {
                    artifact.setUri(artifact.getUri());
                    SolrArtifactIndexAdmin.handleSolrResponse(solrClient.addBean((Object)artifact), "Problem reindexing artifact [artifactId: " + artifact.getId() + "]");
                }
                SolrArtifactIndexAdmin.handleSolrResponse(solrClient.commit(), "Problem committing changes to Solr");
            }
            catch (IOException | SolrServerException | SolrResponseErrorException e) {
                log.error("Caught exception while performing an in-place reindex of all Solr documents: {}", e);
                throw e;
            }
        }
    }
}

