/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.laaws.rs.index.solr;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.lucene.util.Version;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.ConfigSetAdminRequest;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.response.ConfigSetAdminResponse;
import org.apache.solr.client.solrj.response.CoreAdminResponse;
import org.apache.solr.client.solrj.response.SolrResponseBase;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.lockss.laaws.rs.index.solr.CoreConfigRequest;
import org.lockss.laaws.rs.index.solr.CoreConfigResponse;
import org.lockss.laaws.rs.index.solr.SolrArtifactIndexAdmin;
import org.lockss.laaws.rs.io.index.ArtifactIndex;
import org.lockss.laaws.rs.io.index.solr.SolrArtifactIndex;
import org.lockss.laaws.rs.io.index.solr.SolrResponseErrorException;
import org.lockss.laaws.rs.io.storage.local.LocalWarcArtifactDataStore;
import org.lockss.log.L4JLogger;
import org.lockss.util.ListUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class SolrArtifactIndexAdmin {
    private static final L4JLogger log = L4JLogger.getLogger();
    public static final String DEFAULT_SOLRCORE_NAME = "lockss";
    public static final int LATEST_LOCKSS_CONFIGSET_VERSION = 3;
    public static final Version TARGET_LUCENE_VERSION = Version.fromBits((int)7, (int)2, (int)1);
    public static final String LOCKSS_CONFIGSET_VERSION_KEY = "lockss-configset-version";
    public static final String KEY_ENDPOINT = "endpoint";
    public static final String KEY_SOLRUSERNAME = "user";
    public static final String KEY_SOLRPASSWORD = "password";
    public static final String KEY_ACTION = "action";
    public static final String KEY_CORE = "core";
    public static final String KEY_LOCAL = "local";
    public static final String KEY_COLLECTION = "collection";
    public static final String KEY_CLOUD = "cloud";
    public static final String KEY_ZKHOST = "zkHost";
    public static final String KEY_LOCALDS = "localds";

    private static Map<String, Object> getFieldModifier(String modifier, Object value) {
        HashMap<String, Object> fieldModifier = new HashMap<String, Object>();
        fieldModifier.put(modifier, value);
        return fieldModifier;
    }

    public static boolean coreExists(SolrClient solrClient, String coreName) throws IOException, SolrServerException {
        CoreAdminResponse response = CoreAdminRequest.getStatus((String)coreName, (SolrClient)solrClient);
        return response.getCoreStatus(coreName).size() > 0;
    }

    public List<String> getAvailableConfigSets(SolrClient solrClient) throws IOException, SolrServerException {
        ConfigSetAdminRequest.List listReq = new ConfigSetAdminRequest.List();
        return ((ConfigSetAdminResponse.List)listReq.process(solrClient)).getConfigSets();
    }

    static <T extends SolrResponseBase> T handleSolrResponse(T solrResponse, String errorMessage) throws SolrResponseErrorException {
        log.debug2("solrResponse = {}", solrResponse);
        NamedList solrResponseResponse = solrResponse.getResponse();
        if (solrResponse.getStatus() == 0 && solrResponseResponse.get("error") == null && solrResponseResponse.get("errors") == null) {
            log.debug2("solrResponse indicates success");
            return solrResponse;
        }
        log.trace("solrResponse indicates failure");
        SolrResponseErrorException snzse = new SolrResponseErrorException(errorMessage, solrResponse);
        log.error((Object)snzse);
        throw snzse;
    }

    private static void exit(AdminExitCode exitCode) {
        System.exit(exitCode.getStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void runAction(CommandLine cmd) throws IOException, SolrServerException, SolrResponseErrorException {
        block74: {
            block75: {
                if (cmd.hasOption("local") && cmd.hasOption("cloud")) {
                    throw new IllegalArgumentException("Both --local and --cloud may not be specified at the same time");
                }
                v0 = coreName = cmd.hasOption("core") != false ? cmd.getOptionValue("core") : "lockss";
                if (!cmd.hasOption("local")) break block75;
                solrHome = Paths.get(cmd.getOptionValue("local"), new String[0]);
                var3_5 = cmd.getOptionValue("action");
                var4_8 = -1;
                switch (var3_5.hashCode()) {
                    case -1352294148: {
                        if (!var3_5.equals("create")) break;
                        var4_8 = 0;
                        break;
                    }
                    case -838846263: {
                        if (!var3_5.equals("update")) break;
                        var4_8 = 1;
                        break;
                    }
                    case -819951495: {
                        if (!var3_5.equals("verify")) break;
                        var4_8 = 2;
                        break;
                    }
                    case 652826013: {
                        if (!var3_5.equals("force-reindex")) break;
                        var4_8 = 3;
                        break;
                    }
                    case 1081843739: {
                        if (!var3_5.equals("rebuild")) break;
                        var4_8 = 4;
                        break;
                    }
                    case -1936343560: {
                        if (!var3_5.equals("upgrade-lucene-index")) break;
                        var4_8 = 5;
                        break;
                    }
                    case -1584232478: {
                        if (!var3_5.equals("update-lockss-configset")) break;
                        var4_8 = 6;
                    }
                }
                switch (var4_8) {
                    case 0: {
                        try {
                            LocalSolrCoreAdmin.createCore((Path)Paths.get(cmd.getOptionValue("local"), new String[0]), (String)coreName);
                            break;
                        }
                        catch (SolrException e) {
                            if (e.getMessage().contains("already exists")) {
                                SolrArtifactIndexAdmin.log.info("Core already exists");
                                break;
                            }
                            throw e;
                        }
                    }
                    case 1: {
                        admin1 = LocalSolrCoreAdmin.fromSolrHomeAndCoreName((Path)solrHome, (String)coreName);
                        admin1.update();
                        break;
                    }
                    case 2: {
                        admin2 = LocalSolrCoreAdmin.fromSolrHomeAndCoreName((Path)solrHome, (String)coreName);
                        if (admin2 != null) {
                            updateInProgress = admin2.isUpdateInProgress();
                            reindexInProgress = admin2.isReindexInProgress();
                            if (!updateInProgress && reindexInProgress) {
                                SolrArtifactIndexAdmin.log.error("Detected interrupted update!");
                                SolrArtifactIndexAdmin.exit((AdminExitCode)AdminExitCode.UPDATE_FAILURE);
                            }
                            if (updateInProgress && reindexInProgress) {
                                SolrArtifactIndexAdmin.log.info("Update in-progress in another thread or JVM");
                                SolrArtifactIndexAdmin.exit((AdminExitCode)AdminExitCode.UPDATE_INPROGRESS);
                            }
                            if (admin2.isUpdateAvailable()) {
                                SolrArtifactIndexAdmin.log.info("Update available");
                                SolrArtifactIndexAdmin.exit((AdminExitCode)AdminExitCode.UPDATE_NEEDED);
                            }
                            System.exit(0);
                            break;
                        }
                        SolrArtifactIndexAdmin.log.error("Core not found!");
                        SolrArtifactIndexAdmin.exit((AdminExitCode)AdminExitCode.MISSING_CORE);
                        break;
                    }
                    case 3: {
                        try {
                            admin3 = LocalSolrCoreAdmin.fromSolrHomeAndCoreName((Path)solrHome, (String)coreName);
                            admin3.reindexLatest();
                        }
                        catch (Exception e) {
                            SolrArtifactIndexAdmin.log.error("Caught exception while forcing a full reindex to latest artifact schema", (Throwable)e);
                        }
                        break;
                    }
                    case 4: {
                        if (!cmd.hasOption("localds")) {
                            SolrArtifactIndexAdmin.log.error("No local data store base directories specified");
                            SolrArtifactIndexAdmin.exit((AdminExitCode)AdminExitCode.ERROR);
                        }
                        dirs = cmd.getOptionValue("localds").split(";");
                        baseDirs = (File[])Arrays.stream(dirs).map((Function<String, File>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(java.lang.String ), (Ljava/lang/String;)Ljava/io/File;)()).toArray((IntFunction<File[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$runAction$0(int ), (I)[Ljava/io/File;)());
                        solrClient = new EmbeddedSolrServer(solrHome, coreName);
                        var10_32 = null;
                        index = new SolrArtifactIndex((SolrClient)solrClient, coreName);
                        ds = new LocalWarcArtifactDataStore((ArtifactIndex)index, baseDirs);
                        ds.rebuildIndex((ArtifactIndex)index);
                        if (solrClient == null) break block74;
                        if (var10_32 == null) ** GOTO lbl97
                        try {
                            solrClient.close();
                        }
                        catch (Throwable index) {
                            var10_32.addSuppressed(index);
                        }
                        break;
lbl97:
                        // 1 sources

                        solrClient.close();
                        break;
                        catch (Throwable index) {
                            try {
                                var10_32 = index;
                                throw index;
                            }
                            catch (Throwable var13_43) {
                                if (solrClient != null) {
                                    if (var10_32 != null) {
                                        try {
                                            solrClient.close();
                                        }
                                        catch (Throwable var14_44) {
                                            var10_32.addSuppressed(var14_44);
                                        }
                                    } else {
                                        solrClient.close();
                                    }
                                }
                                throw var13_43;
                            }
                        }
                    }
                    case 5: {
                        admin4 = LocalSolrCoreAdmin.fromSolrHomeAndCoreName((Path)solrHome, (String)coreName);
                        admin4.upgradeLuceneIndex();
                        System.exit(0);
                        break;
                    }
                    case 6: {
                        try {
                            admin5 = LocalSolrCoreAdmin.fromSolrHomeAndCoreName((Path)solrHome, (String)coreName);
                            if (admin5.isLockssConfigSetUpdateAvailable()) {
                                targetVersion = admin5.getLockssConfigSetVersion() + 1;
                                admin5.retireConfigSet();
                                admin5.installLockssConfigSetVersion(targetVersion);
                                System.exit(0);
                                break;
                            }
                            System.exit(1);
                        }
                        catch (Exception e) {
                            SolrArtifactIndexAdmin.log.error("Could not install LOCKSS configuration set", (Throwable)e);
                            System.exit(2);
                        }
                        break;
                    }
                    default: {
                        SolrArtifactIndexAdmin.log.error("Unknown action to perform [action: {}]", (Object)cmd.getOptionValue("action"));
                        throw new IllegalArgumentException("Unknown action");
                    }
                }
                break block74;
            }
            if (cmd.hasOption("endpoint")) {
                solrClient = new HttpSolrClient.Builder().withBaseSolrUrl(cmd.getOptionValue("endpoint")).build();
                try {
                    var3_6 = cmd.getOptionValue("action");
                    var4_9 = -1;
                    switch (var3_6.hashCode()) {
                        case 655643859: {
                            if (!var3_6.equals("apply-lockss-configset-changes")) break;
                            var4_9 = 0;
                            break;
                        }
                        case 1081843739: {
                            if (!var3_6.equals("rebuild")) break;
                            var4_9 = 1;
                        }
                    }
                    switch (var4_9) {
                        case 0: {
                            req = new CoreConfigRequest.Overlay();
                            if (cmd.hasOption("user")) {
                                req.setBasicAuthCredentials(cmd.getOptionValue("user"), cmd.getOptionValue("password"));
                            }
                            res = (CoreConfigResponse.Overlay)req.process((SolrClient)solrClient);
                            targetVersion = res.getLockssConfigSetVersion();
                            credentials = null;
                            if (cmd.hasOption("user")) {
                                credentials = ListUtil.list((Object[])new String[]{cmd.getOptionValue("user"), cmd.getOptionValue("password")});
                            }
                            SolrArtifactIndexReindex.reindexArtifactsForVersion((SolrClient)solrClient, credentials, (String)coreName, (int)targetVersion);
                            ** break;
lbl165:
                            // 1 sources

                        }
                        case 1: {
                            if (!cmd.hasOption("localds")) {
                                SolrArtifactIndexAdmin.log.error("No local data store base directories specified");
                                SolrArtifactIndexAdmin.exit((AdminExitCode)AdminExitCode.ERROR);
                            }
                            dirs = cmd.getOptionValue("localds").split(";");
                            baseDirs = (File[])Arrays.stream(dirs).map((Function<String, File>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(java.lang.String ), (Ljava/lang/String;)Ljava/io/File;)()).toArray((IntFunction<File[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$runAction$1(int ), (I)[Ljava/io/File;)());
                            index = new SolrArtifactIndex((SolrClient)solrClient, coreName);
                            ds = new LocalWarcArtifactDataStore((ArtifactIndex)index, baseDirs);
                            ds.rebuildIndex((ArtifactIndex)index);
                            ** break;
lbl176:
                            // 1 sources

                        }
                        default: {
                            throw new IllegalArgumentException("Unknown action: " + cmd.getOptionValue("action"));
                        }
                    }
                }
                finally {
                    solrClient.close();
                }
            } else if (cmd.hasOption("cloud")) {
                solrUrl = cmd.getOptionValue("cloud");
                cloudClient = new CloudSolrClient.Builder().withSolrUrl(solrUrl).withZkHost(cmd.getOptionValue("zkHost")).build();
                var4_10 = null;
                try {
                    collection = cmd.hasOption("collection") != false ? cmd.getOptionValue("collection") : "lockss";
                    cloudClient.setDefaultCollection(collection);
                    credentials = null;
                    if (cmd.hasOption("user")) {
                        credentials = ListUtil.list((Object[])new String[]{cmd.getOptionValue("user"), cmd.getOptionValue("password")});
                    }
                    updater = SolrCloudCollectionAdmin.fromCloudSolrClient((CloudSolrClient)cloudClient, credentials);
                    updater.update();
                }
                catch (Throwable var5_16) {
                    var4_10 = var5_16;
                    throw var5_16;
                }
                finally {
                    if (cloudClient != null) {
                        if (var4_10 != null) {
                            try {
                                cloudClient.close();
                            }
                            catch (Throwable var5_15) {
                                var4_10.addSuppressed(var5_15);
                            }
                        } else {
                            cloudClient.close();
                        }
                    }
                }
            } else {
                throw new IllegalArgumentException("--local, --endpoint, or --cloud must be specified");
            }
        }
    }

    public static void main(String[] args) throws ParseException, IOException, SolrResponseErrorException, SolrServerException {
        Options options = new Options();
        options.addOption(null, "action", true, "Action to perform (create, update, force-reindex, rebuild or verify)");
        options.addOption(null, "core", true, "Name of Solr core");
        options.addOption(null, "local", true, "Path to Solr home base directory");
        options.addOption(null, "endpoint", true, "Solr REST endpoint");
        options.addOption(null, "user", true, "Solr username");
        options.addOption(null, "password", true, "Solr password");
        options.addOption(null, "collection", true, "Name of Solr Cloud collection");
        options.addOption(null, "cloud", true, "Solr Cloud REST endpoint");
        options.addOption(null, "zkHost", true, "ZooKeeper REST endpoint used by Solr Cloud cluster");
        options.addOption(null, "localds", true, "Local data store base directories");
        try {
            CommandLine cmd = new PosixParser().parse(options, args);
            SolrArtifactIndexAdmin.runAction((CommandLine)cmd);
            SolrArtifactIndexAdmin.exit((AdminExitCode)AdminExitCode.OK);
        }
        catch (Exception e) {
            log.error("Exception caught", (Throwable)e);
            SolrArtifactIndexAdmin.exit((AdminExitCode)AdminExitCode.ERROR);
        }
    }

    private static /* synthetic */ File[] lambda$runAction$1(int x$0) {
        return new File[x$0];
    }

    private static /* synthetic */ File[] lambda$runAction$0(int x$0) {
        return new File[x$0];
    }

    static /* synthetic */ L4JLogger access$000() {
        return log;
    }

    static /* synthetic */ Map access$100(String x0, Object x1) {
        return SolrArtifactIndexAdmin.getFieldModifier((String)x0, (Object)x1);
    }
}

