/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.ws;

import org.lockss.util.rest.RestUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.web.client.RestTemplate;

@Configuration
public class RestTemplateConfig {
    @Autowired
    protected Environment env;
    public static final String CONNECTION_TIMEOUT_KEY = "connection.timeout";
    public static final String READ_TIMEOUT_KEY = "read.timeout";
    private final long defaultConnectTimeout = 10000L;
    private final long defaultReadTimeout = 120000L;

    @Bean
    protected RestTemplate restTemplate() {
        return RestUtil.getRestTemplate((long)this.getConnectionTimeout(), (long)this.getReadTimeout());
    }

    protected Long getConnectionTimeout() {
        return (Long)this.env.getProperty(CONNECTION_TIMEOUT_KEY, Long.class, (Object)10000L);
    }

    protected Long getReadTimeout() {
        return (Long)this.env.getProperty(READ_TIMEOUT_KEY, Long.class, (Object)120000L);
    }
}

