/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.ws.content;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.cxf.jaxrs.ext.multipart.InputStreamDataSource;
import org.lockss.laaws.rs.core.LockssRepository;
import org.lockss.laaws.rs.model.Artifact;
import org.lockss.laaws.rs.model.ArtifactData;
import org.lockss.log.L4JLogger;
import org.lockss.ws.BaseServiceImpl;
import org.lockss.ws.content.ContentService;
import org.lockss.ws.entities.ContentResult;
import org.lockss.ws.entities.FileWsResult;
import org.lockss.ws.entities.LockssWebServicesFault;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Service;

@Service
public class ContentServiceImpl
extends BaseServiceImpl
implements ContentService {
    private static final L4JLogger log = L4JLogger.getLogger();

    @Override
    public List<FileWsResult> getVersions(String url, String auId) throws LockssWebServicesFault {
        log.debug2("url = {}", (Object)url);
        log.debug2("auId = {}", (Object)auId);
        try {
            ArrayList<FileWsResult> result = new ArrayList<FileWsResult>();
            for (Artifact artifact : this.getRestLockssRepository().getArtifactsAllVersions(this.repoNamespace, auId, url)) {
                log.trace("artifact = {}", (Object)artifact);
                FileWsResult fileWsResult = new FileWsResult();
                fileWsResult.setUrl(artifact.getUri());
                fileWsResult.setVersion(artifact.getVersion());
                fileWsResult.setSize(Long.valueOf(artifact.getContentLength()));
                fileWsResult.setCollectionDate(Long.valueOf(artifact.getCollectionDate()));
                result.add(fileWsResult);
            }
            log.debug2("result = {}", result);
            return result;
        }
        catch (Exception e) {
            throw new LockssWebServicesFault((Throwable)e);
        }
    }

    @Override
    public boolean isUrlCached(String url, String auId) throws LockssWebServicesFault {
        log.debug2("url = {}", (Object)url);
        log.debug2("auId = {}", (Object)auId);
        try {
            boolean result = this.getRestLockssRepository().getArtifact(this.repoNamespace, auId, url) != null;
            log.debug2("result = {}", (Object)result);
            return result;
        }
        catch (Exception e) {
            throw new LockssWebServicesFault((Throwable)e);
        }
    }

    @Override
    public boolean isUrlVersionCached(String url, String auId, Integer version) throws LockssWebServicesFault {
        log.debug2("url = {}", (Object)url);
        log.debug2("auId = {}", (Object)auId);
        log.debug2("version = {}", (Object)version);
        try {
            boolean result = this.getRestLockssRepository().getArtifactVersion(this.repoNamespace, auId, url, version, false) != null;
            log.debug2("result = {}", (Object)result);
            return result;
        }
        catch (Exception e) {
            throw new LockssWebServicesFault((Throwable)e);
        }
    }

    @Override
    public ContentResult fetchFile(String url, String auId) throws LockssWebServicesFault {
        log.debug2("url = {}", (Object)url);
        log.debug2("auId = {}", (Object)auId);
        try {
            if (auId == null || auId.isEmpty()) {
                throw new IllegalArgumentException("Missing required Archival Unit identifier (auId)");
            }
            if (url == null || url.isEmpty()) {
                throw new IllegalArgumentException("Missing required URL");
            }
            ContentResult result = new ContentResult();
            Artifact artifact = this.getRestLockssRepository().getArtifact(this.repoNamespace, auId, url);
            log.trace("artifact = {}", (Object)artifact);
            if (artifact != null) {
                result = this.getContentResultFromArtifact(artifact);
            }
            log.debug2("result = {}", (Object)result);
            return result;
        }
        catch (Exception e) {
            throw new LockssWebServicesFault((Throwable)e);
        }
    }

    @Override
    public ContentResult fetchVersionedFile(String url, String auId, Integer version) throws LockssWebServicesFault {
        log.debug2("url = {}", (Object)url);
        log.debug2("auId = {}", (Object)auId);
        log.debug2("version = {}", (Object)version);
        try {
            if (auId == null || auId.isEmpty()) {
                throw new IllegalArgumentException("Missing required Archival Unit identifier (auId)");
            }
            if (url == null || url.isEmpty()) {
                throw new IllegalArgumentException("Missing required URL");
            }
            if (version == null) {
                throw new IllegalArgumentException("Missing required version");
            }
            ContentResult result = new ContentResult();
            Artifact artifact = this.getRestLockssRepository().getArtifactVersion(this.repoNamespace, auId, url, version, false);
            log.trace("artifact = {}", (Object)artifact);
            if (artifact != null) {
                result = this.getContentResultFromArtifact(artifact);
            }
            log.debug2("result = {}", (Object)result);
            return result;
        }
        catch (Exception e) {
            throw new LockssWebServicesFault((Throwable)e);
        }
    }

    private ContentResult getContentResultFromArtifact(Artifact artifact) throws Exception {
        ContentResult result = new ContentResult();
        ArtifactData artifactData = this.getRestLockssRepository().getArtifactData(artifact, LockssRepository.IncludeContent.ALWAYS);
        if (artifactData != null) {
            HttpHeaders headers = artifactData.getHttpHeaders();
            String contentType = headers.getFirst("Content-Type");
            result.setDataHandler(new DataHandler((DataSource)new InputStreamDataSource(artifactData.getInputStream(), contentType, artifact.getUri())));
            Properties props = new Properties();
            for (String key : artifactData.getHttpHeaders().keySet()) {
                String value = ContentServiceImpl.separatedString(artifactData.getHttpHeaders().get((Object)key), "", ",", "", new StringBuilder()).toString();
                props.setProperty(key, value);
            }
            result.setProperties(props);
        }
        log.debug2("result = {}", (Object)result);
        return result;
    }
}

