/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.ws.status;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.lockss.app.ServiceDescr;
import org.lockss.laaws.rs.model.Artifact;
import org.lockss.log.L4JLogger;
import org.lockss.util.rest.exception.LockssRestException;
import org.lockss.util.rest.poller.RestPollerClient;
import org.lockss.util.rest.status.RestStatusClient;
import org.lockss.ws.BaseServiceImpl;
import org.lockss.ws.entities.AuStatus;
import org.lockss.ws.entities.AuWsResult;
import org.lockss.ws.entities.CrawlWsResult;
import org.lockss.ws.entities.IdNamePair;
import org.lockss.ws.entities.LockssWebServicesFault;
import org.lockss.ws.entities.PeerWsResult;
import org.lockss.ws.entities.PlatformConfigurationWsResult;
import org.lockss.ws.entities.PluginWsResult;
import org.lockss.ws.entities.PollWsResult;
import org.lockss.ws.entities.RepositorySpaceWsResult;
import org.lockss.ws.entities.RepositoryWsResult;
import org.lockss.ws.entities.TdbAuWsResult;
import org.lockss.ws.entities.TdbPublisherWsResult;
import org.lockss.ws.entities.TdbTitleWsResult;
import org.lockss.ws.entities.VoteWsResult;
import org.lockss.ws.status.DaemonStatusService;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class DaemonStatusServiceImpl
extends BaseServiceImpl
implements DaemonStatusService {
    private static final L4JLogger log = L4JLogger.getLogger();

    @Override
    public boolean isDaemonReady() throws LockssWebServicesFault {
        log.debug2("Invoked.");
        try {
            boolean result = true;
            String url = this.getServiceEndpoint(ServiceDescr.SVC_REPO);
            if (url != null && !(result = this.isServiceReady(url))) {
                log.debug2("result = {}", (Object)result);
                return result;
            }
            url = this.getServiceEndpoint(ServiceDescr.SVC_CONFIG);
            if (url != null && !(result = this.isServiceReady(url))) {
                log.debug2("result = {}", (Object)result);
                return result;
            }
            url = this.getServiceEndpoint(ServiceDescr.SVC_POLLER);
            if (url != null && !(result = this.isServiceReady(url))) {
                log.debug2("result = {}", (Object)result);
                return result;
            }
            url = this.getServiceEndpoint(ServiceDescr.SVC_MDX);
            if (url != null && !(result = this.isServiceReady(url))) {
                log.debug2("result = {}", (Object)result);
                return result;
            }
            url = this.getServiceEndpoint(ServiceDescr.SVC_MDQ);
            if (url != null) {
                result = this.isServiceReady(url);
            }
            log.debug2("result = {}", (Object)result);
            return result;
        }
        catch (Exception e) {
            throw new LockssWebServicesFault((Throwable)e);
        }
    }

    private boolean isServiceReady(String serviceUrl) {
        log.debug2("serviceUrl = {}", (Object)serviceUrl);
        boolean isReady = false;
        try {
            isReady = ((RestStatusClient)new RestStatusClient(serviceUrl).setRestTemplate(this.restTemplate)).getStatus().isReady();
        }
        catch (LockssRestException lre) {
            log.debug("Ignored exception caught getting status of " + serviceUrl, (Throwable)lre);
        }
        log.debug2("isReady = {}", (Object)isReady);
        return isReady;
    }

    @Override
    public Collection<IdNamePair> getAuIds() throws LockssWebServicesFault {
        log.debug2("Invoked.");
        List<AuWsResult> queryAusResult = this.queryAus("select auId, name");
        log.trace("queryAusResult = {}", queryAusResult);
        try {
            ArrayList<IdNamePair> results = new ArrayList<IdNamePair>(queryAusResult.size());
            for (AuWsResult auWsResult : queryAusResult) {
                results.add(new IdNamePair(auWsResult.getAuId(), auWsResult.getName()));
            }
            log.debug2("results = {}", results);
            return results;
        }
        catch (Exception e) {
            throw new LockssWebServicesFault((Throwable)e);
        }
    }

    @Override
    public AuStatus getAuStatus(String auId) throws LockssWebServicesFault {
        log.debug2("auId = {}", (Object)auId);
        try {
            HashMap<String, String> uriVariables = new HashMap<String, String>(1);
            uriVariables.put("auId", auId);
            log.trace("uriVariables = {}", uriVariables);
            ResponseEntity<String> response = this.callRestServiceEndpoint(this.getServiceEndpoint(ServiceDescr.SVC_CONFIG), "/austatuses/{auId}", uriVariables, null, HttpMethod.GET, null, "Can't get AU status");
            try {
                ObjectMapper mapper = new ObjectMapper();
                AuStatus result = (AuStatus)mapper.readValue((String)response.getBody(), AuStatus.class);
                log.debug2("result = " + result);
                return result;
            }
            catch (Exception e) {
                log.error("Cannot get body of response", (Throwable)e);
                throw e;
            }
        }
        catch (Exception e) {
            throw new LockssWebServicesFault((Throwable)e);
        }
    }

    @Override
    public List<PluginWsResult> queryPlugins(String pluginQuery) throws LockssWebServicesFault {
        log.debug2("pluginQuery = {}", (Object)pluginQuery);
        try {
            HashMap<String, String> queryParams = new HashMap<String, String>(1);
            queryParams.put("pluginQuery", pluginQuery);
            log.trace("queryParams = {}", queryParams);
            ResponseEntity<String> response = this.callRestServiceEndpoint(this.getServiceEndpoint(ServiceDescr.SVC_CONFIG), "/plugins", null, queryParams, HttpMethod.GET, null, "Can't query plugins");
            try {
                ObjectMapper mapper = new ObjectMapper();
                List result = (List)mapper.readValue((String)response.getBody(), (TypeReference)new TypeReference<List<PluginWsResult>>(){});
                log.debug2("result = " + result);
                return result;
            }
            catch (Exception e) {
                log.error("Cannot get body of response", (Throwable)e);
                throw e;
            }
        }
        catch (Exception e) {
            throw new LockssWebServicesFault((Throwable)e);
        }
    }

    @Override
    public List<AuWsResult> queryAus(String auQuery) throws LockssWebServicesFault {
        log.debug2("auQuery = {}", (Object)auQuery);
        try {
            HashMap<String, String> queryParams = new HashMap<String, String>(1);
            queryParams.put("auQuery", auQuery);
            log.trace("queryParams = {}", queryParams);
            ResponseEntity<String> response = this.callRestServiceEndpoint(this.getServiceEndpoint(ServiceDescr.SVC_CONFIG), "/auqueries", null, queryParams, HttpMethod.GET, null, "Can't query AUs");
            try {
                ObjectMapper mapper = new ObjectMapper();
                List result = (List)mapper.readValue((String)response.getBody(), (TypeReference)new TypeReference<List<AuWsResult>>(){});
                log.debug2("result = " + result);
                return result;
            }
            catch (Exception e) {
                log.error("Cannot get body of response", (Throwable)e);
                throw e;
            }
        }
        catch (Exception e) {
            throw new LockssWebServicesFault((Throwable)e);
        }
    }

    @Override
    public List<PeerWsResult> queryPeers(String peerQuery) throws LockssWebServicesFault {
        log.debug2("peerQuery = {}", (Object)peerQuery);
        try {
            List results = ((RestPollerClient)((RestPollerClient)new RestPollerClient(this.getServiceEndpoint(ServiceDescr.SVC_POLLER)).addRequestHeaders(this.getAuthHeaders())).setRestTemplate(this.restTemplate)).queryPeers(peerQuery);
            log.debug2("results = {}", (Object)results);
            return results;
        }
        catch (Exception e) {
            throw new LockssWebServicesFault((Throwable)e);
        }
    }

    @Override
    public List<VoteWsResult> queryVotes(String voteQuery) throws LockssWebServicesFault {
        log.debug2("voteQuery = {}", (Object)voteQuery);
        try {
            List results = ((RestPollerClient)((RestPollerClient)new RestPollerClient(this.getServiceEndpoint(ServiceDescr.SVC_POLLER)).addRequestHeaders(this.getAuthHeaders())).setRestTemplate(this.restTemplate)).queryVotes(voteQuery);
            log.debug2("results = {}", (Object)results);
            return results;
        }
        catch (Exception e) {
            throw new LockssWebServicesFault((Throwable)e);
        }
    }

    @Override
    public List<RepositorySpaceWsResult> queryRepositorySpaces(String repositorySpaceQuery) throws LockssWebServicesFault {
        log.debug2("repositorySpaceQuery = {}", (Object)repositorySpaceQuery);
        try {
            List results = ((RestPollerClient)((RestPollerClient)new RestPollerClient(this.getServiceEndpoint(ServiceDescr.SVC_POLLER)).addRequestHeaders(this.getAuthHeaders())).setRestTemplate(this.restTemplate)).queryRepositorySpaces(repositorySpaceQuery);
            log.debug2("results = {}", (Object)results);
            return results;
        }
        catch (Exception e) {
            throw new LockssWebServicesFault((Throwable)e);
        }
    }

    @Override
    public List<RepositoryWsResult> queryRepositories(String repositoryQuery) throws LockssWebServicesFault {
        log.debug2("repositoryQuery = {}", (Object)repositoryQuery);
        try {
            List results = ((RestPollerClient)((RestPollerClient)new RestPollerClient(this.getServiceEndpoint(ServiceDescr.SVC_POLLER)).addRequestHeaders(this.getAuthHeaders())).setRestTemplate(this.restTemplate)).queryAuRepositories(repositoryQuery);
            log.debug2("results = {}", (Object)results);
            return results;
        }
        catch (Exception e) {
            throw new LockssWebServicesFault((Throwable)e);
        }
    }

    @Override
    public List<CrawlWsResult> queryCrawls(String crawlQuery) throws LockssWebServicesFault {
        log.debug2("crawlQuery = {}", (Object)crawlQuery);
        try {
            ArrayList<CrawlWsResult> results = new ArrayList<CrawlWsResult>();
            log.debug2("results = {}", results);
            return results;
        }
        catch (Exception e) {
            throw new LockssWebServicesFault((Throwable)e);
        }
    }

    @Override
    public List<PollWsResult> queryPolls(String pollQuery) throws LockssWebServicesFault {
        log.debug2("pollQuery = {}", (Object)pollQuery);
        try {
            List results = ((RestPollerClient)((RestPollerClient)new RestPollerClient(this.getServiceEndpoint(ServiceDescr.SVC_POLLER)).addRequestHeaders(this.getAuthHeaders())).setRestTemplate(this.restTemplate)).queryPolls(pollQuery);
            log.debug2("results = {}", (Object)results);
            return results;
        }
        catch (Exception e) {
            throw new LockssWebServicesFault((Throwable)e);
        }
    }

    @Override
    public PlatformConfigurationWsResult getPlatformConfiguration() throws LockssWebServicesFault {
        log.debug2("Invoked.");
        try {
            ResponseEntity<String> response = this.callRestServiceEndpoint(this.getServiceEndpoint(ServiceDescr.SVC_CONFIG), "/config/platform", null, null, HttpMethod.GET, null, "Can't get platform configuration");
            try {
                ObjectMapper mapper = new ObjectMapper();
                PlatformConfigurationWsResult result = (PlatformConfigurationWsResult)mapper.readValue((String)response.getBody(), PlatformConfigurationWsResult.class);
                log.debug2("result = " + result);
                return result;
            }
            catch (Exception e) {
                log.error("Cannot get body of response", (Throwable)e);
                throw e;
            }
        }
        catch (Exception e) {
            throw new LockssWebServicesFault((Throwable)e);
        }
    }

    @Override
    public List<TdbPublisherWsResult> queryTdbPublishers(String tdbPublisherQuery) throws LockssWebServicesFault {
        log.debug2("tdbPublisherQuery = {}", (Object)tdbPublisherQuery);
        try {
            HashMap<String, String> queryParams = new HashMap<String, String>(1);
            queryParams.put("tdbPublisherQuery", tdbPublisherQuery);
            log.trace("queryParams = {}", queryParams);
            ResponseEntity<String> response = this.callRestServiceEndpoint(this.getServiceEndpoint(ServiceDescr.SVC_CONFIG), "/tdbpublishers", null, queryParams, HttpMethod.GET, null, "Can't query TDB publishers");
            try {
                ObjectMapper mapper = new ObjectMapper();
                List result = (List)mapper.readValue((String)response.getBody(), (TypeReference)new TypeReference<List<TdbPublisherWsResult>>(){});
                log.debug2("result = " + result);
                return result;
            }
            catch (Exception e) {
                log.error("Cannot get body of response", (Throwable)e);
                throw e;
            }
        }
        catch (Exception e) {
            throw new LockssWebServicesFault((Throwable)e);
        }
    }

    @Override
    public List<TdbTitleWsResult> queryTdbTitles(String tdbTitleQuery) throws LockssWebServicesFault {
        log.debug2("tdbTitleQuery = {}", (Object)tdbTitleQuery);
        try {
            HashMap<String, String> queryParams = new HashMap<String, String>(1);
            queryParams.put("tdbTitleQuery", tdbTitleQuery);
            log.trace("queryParams = {}", queryParams);
            ResponseEntity<String> response = this.callRestServiceEndpoint(this.getServiceEndpoint(ServiceDescr.SVC_CONFIG), "/tdbtitles", null, queryParams, HttpMethod.GET, null, "Can't query TDB titles");
            try {
                ObjectMapper mapper = new ObjectMapper();
                List result = (List)mapper.readValue((String)response.getBody(), (TypeReference)new TypeReference<List<TdbTitleWsResult>>(){});
                log.debug2("result = " + result);
                return result;
            }
            catch (Exception e) {
                log.error("Cannot get body of response", (Throwable)e);
                throw e;
            }
        }
        catch (Exception e) {
            throw new LockssWebServicesFault((Throwable)e);
        }
    }

    @Override
    public List<TdbAuWsResult> queryTdbAus(String tdbAuQuery) throws LockssWebServicesFault {
        log.debug2("tdbAuQuery = {}", (Object)tdbAuQuery);
        try {
            HashMap<String, String> queryParams = new HashMap<String, String>(1);
            queryParams.put("tdbAuQuery", tdbAuQuery);
            log.trace("queryParams = {}", queryParams);
            ResponseEntity<String> response = this.callRestServiceEndpoint(this.getServiceEndpoint(ServiceDescr.SVC_CONFIG), "/tdbaus", null, queryParams, HttpMethod.GET, null, "Can't query TDB AUs");
            try {
                ObjectMapper mapper = new ObjectMapper();
                List result = (List)mapper.readValue((String)response.getBody(), (TypeReference)new TypeReference<List<TdbAuWsResult>>(){});
                log.debug2("result = " + result);
                return result;
            }
            catch (Exception e) {
                log.error("Cannot get body of response", (Throwable)e);
                throw e;
            }
        }
        catch (Exception e) {
            throw new LockssWebServicesFault((Throwable)e);
        }
    }

    @Override
    public List<String> getAuUrls(String auId, String url) throws LockssWebServicesFault {
        log.debug2("auId = {}", (Object)auId);
        log.debug2("url = {}", (Object)url);
        try {
            ArrayList<String> results = new ArrayList<String>();
            String prefixUrl = url == null ? "" : url;
            log.trace("prefixUrl = {}", (Object)prefixUrl);
            for (Artifact artifact : this.getRestLockssRepository().getArtifactsWithPrefix(this.repoNamespace, auId, prefixUrl)) {
                log.trace("artifact = {}", (Object)artifact);
                results.add(artifact.getUri());
            }
            log.debug2("results = {}", results);
            return results;
        }
        catch (Exception e) {
            throw new LockssWebServicesFault((Throwable)e);
        }
    }
}

