/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.ws;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.lockss.app.LockssDaemon;
import org.lockss.app.ServiceBinding;
import org.lockss.app.ServiceDescr;
import org.lockss.config.Configuration;
import org.lockss.log.L4JLogger;
import org.lockss.spring.base.BaseSpringApiServiceImpl;
import org.lockss.spring.base.LockssConfigurableService;
import org.lockss.util.auth.AuthUtil;
import org.lockss.util.rest.RestUtil;
import org.lockss.util.rest.SpringHeaderUtil;
import org.lockss.util.rest.exception.LockssRestException;
import org.lockss.util.rest.multipart.MultipartConnector;
import org.lockss.util.rest.multipart.MultipartResponse;
import org.lockss.util.rest.repo.RestLockssRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
public class BaseServiceImpl
extends BaseSpringApiServiceImpl
implements LockssConfigurableService {
    public static final String PREFIX = "org.lockss.soap.";
    public static final String PARAM_REPO_NAMESPACE = "org.lockss.soap.repository.namespace";
    public static final String DEFAULT_REPO_NAMESPACE = null;
    public static final String PARAM_CONNECTION_TIMEOUT = "org.lockss.soap.connection.timeout";
    public static final long DEFAULT_CONNECTION_TIMEOUT = 10000L;
    public static final String PARAM_READ_TIMEOUT = "org.lockss.soap.read.timeout";
    public static final long DEFAULT_READ_TIMEOUT = 120000L;
    private static final L4JLogger log = L4JLogger.getLogger();
    @Autowired
    protected RestTemplate restTemplate;
    protected long connectionTimeout = 10000L;
    protected long readTimeout = 120000L;
    protected String repoNamespace = DEFAULT_REPO_NAMESPACE;

    protected ServiceBinding getServiceBinding(ServiceDescr sd) {
        LockssDaemon daemon = this.getRunningLockssDaemon();
        if (daemon == null) {
            throw new IllegalStateException("No running LockssDaemon, can't access service bindings");
        }
        return daemon.getServiceBinding(sd);
    }

    public String getServiceEndpoint(ServiceDescr sd) {
        ServiceBinding binding = this.getServiceBinding(sd);
        if (binding == null) {
            throw new IllegalArgumentException("No service binding for " + sd);
        }
        return this.getServiceBinding(sd).getRestStem();
    }

    protected Long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    protected Long getReadTimeout() {
        return this.readTimeout;
    }

    protected HttpHeaders getAuthHeaders() {
        String reqIp;
        HttpHeaders hdrs = new HttpHeaders();
        String auth = BaseServiceImpl.getSoapRequestAuthorizationHeader();
        if (!StringUtils.isEmpty((CharSequence)auth)) {
            hdrs.set("Authorization", auth);
        }
        if (!StringUtils.isEmpty((CharSequence)(reqIp = BaseServiceImpl.getRequestorIpAddress()))) {
            hdrs.set("X-Forwarded-For", reqIp);
        }
        return hdrs;
    }

    protected static String getSoapRequestAuthorizationHeader() {
        log.debug2("Invoked.");
        String authHeaderValue = null;
        Map soapHeaders = CastUtils.cast((Map)((Map)PhaseInterceptorChain.getCurrentMessage().get((Object)Message.PROTOCOL_HEADERS)));
        log.trace("soapHeaders = {}", (Object)soapHeaders);
        if (soapHeaders != null) {
            List authHeaders = (List)soapHeaders.get("Authorization");
            log.trace("authHeaders = {}", (Object)authHeaders);
            if (authHeaders != null && !authHeaders.isEmpty()) {
                authHeaderValue = (String)authHeaders.get(0);
            }
        }
        log.debug2("authHeaderValue = {}", authHeaderValue);
        return authHeaderValue;
    }

    protected static String getRequestorIpAddress() {
        Message message = PhaseInterceptorChain.getCurrentMessage();
        HttpServletRequest request = (HttpServletRequest)message.get((Object)"HTTP.REQUEST");
        String srcIp = request.getRemoteAddr();
        log.debug2("src IP = {}", (Object)srcIp);
        return srcIp;
    }

    protected RestLockssRepository getRestLockssRepository() throws MalformedURLException {
        String[] credentials = BaseServiceImpl.getSoapRequestCredentials();
        log.trace("credentials = [{}, ****]", (Object)credentials[0]);
        try {
            return new RestLockssRepository(new URL(this.getServiceEndpoint(ServiceDescr.SVC_REPO)), this.restTemplate, credentials[0], credentials[1]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not create REST LOCKSS Repository client");
        }
    }

    protected static String[] getSoapRequestCredentials() {
        log.debug2("Invoked.");
        String[] credentials = new String[]{null, null};
        String authHeaderValue = BaseServiceImpl.getSoapRequestAuthorizationHeader();
        log.debug2("authHeaderValue = {}", (Object)authHeaderValue);
        if (authHeaderValue != null) {
            credentials = AuthUtil.decodeBasicAuthorizationHeader((String)BaseServiceImpl.getSoapRequestAuthorizationHeader());
            log.debug2("credentials = [{}, ****]", (Object)credentials[0]);
        }
        return credentials;
    }

    protected <T> ResponseEntity<String> callRestServiceEndpoint(String serviceUrl, String endPointPath, Map<String, String> uriVariables, Map<String, String> queryParams, HttpMethod httpMethod, T body, String exceptionMessage) throws LockssRestException {
        return this.callRestServiceUri(serviceUrl + endPointPath, uriVariables, queryParams, httpMethod, body, exceptionMessage);
    }

    protected <T> ResponseEntity<String> callRestServiceUri(String uriString, Map<String, String> uriVariables, Map<String, String> queryParams, HttpMethod httpMethod, T body, String exceptionMessage) throws LockssRestException {
        return this.callRestServiceUri(uriString, uriVariables, queryParams, httpMethod, new HttpHeaders(), body, exceptionMessage);
    }

    protected <T> ResponseEntity<String> callRestServiceUri(String uriString, Map<String, String> uriVariables, Map<String, String> queryParams, HttpMethod httpMethod, HttpHeaders requestHeaders, T body, String exceptionMessage) throws LockssRestException {
        log.debug2("uriString = {}", (Object)uriString);
        log.debug2("uriVariables = {}", uriVariables);
        log.debug2("queryParams = {}", queryParams);
        log.debug2("httpMethod = {}", (Object)httpMethod);
        log.debug2("body = {}", body);
        log.debug2("requestHeaders = {}", (Object)requestHeaders);
        log.debug2("exceptionMessage = {}", (Object)exceptionMessage);
        URI uri = RestUtil.getRestUri((String)uriString, uriVariables, queryParams);
        log.trace("uri = {}", (Object)uri);
        SpringHeaderUtil.addHeaders((HttpHeaders)this.getAuthHeaders(), (HttpHeaders)requestHeaders, (boolean)true);
        log.trace("requestHeaders = {}", (Object)requestHeaders);
        log.trace("Calling RestUtil.callRestService");
        return RestUtil.callRestService((RestTemplate)this.restTemplate, (URI)uri, (HttpMethod)httpMethod, (HttpEntity)new HttpEntity(body, (MultiValueMap)requestHeaders), String.class, (String)exceptionMessage);
    }

    protected <T> MultipartResponse getMultipartResponse(String serviceUrl, String endPointPath, Map<String, String> uriVariables, Map<String, String> queryParams, HttpHeaders requestHeaders, HttpMethod httpMethod, T body) throws IOException, MessagingException {
        log.debug2("serviceUrl = {}", (Object)serviceUrl);
        log.debug2("endPointPath = {}", (Object)endPointPath);
        log.debug2("uriVariables = {}", uriVariables);
        log.debug2("queryParams = {}", queryParams);
        log.debug2("requestHeaders = {}", (Object)requestHeaders);
        log.debug2("httpMethod = {}", (Object)httpMethod);
        log.debug2("body = {}", body);
        URI uri = RestUtil.getRestUri((String)(serviceUrl + endPointPath), uriVariables, queryParams);
        log.trace("uri = {}", (Object)uri);
        requestHeaders.setAccept(Arrays.asList(MediaType.MULTIPART_FORM_DATA, MediaType.APPLICATION_JSON));
        SpringHeaderUtil.addHeaders((HttpHeaders)this.getAuthHeaders(), (HttpHeaders)requestHeaders, (boolean)true);
        log.trace("requestHeaders = {}", (Object)requestHeaders);
        log.trace("Calling MultipartConnector.requestGet");
        return new MultipartConnector(uri, requestHeaders).request(httpMethod, body, (long)this.getConnectionTimeout().intValue(), (long)this.getReadTimeout().intValue());
    }

    protected static StringBuilder separatedString(Collection c, String separatorFirst, String separatorInner, String separatorLast, StringBuilder sb) {
        if (c == null) {
            return sb;
        }
        Iterator iter = c.iterator();
        boolean first = true;
        String NULL_OBJECT_PRINTABLE_TEXT = "(null)";
        while (iter.hasNext()) {
            if (first) {
                first = false;
                sb.append(separatorFirst);
            } else {
                sb.append(separatorInner);
            }
            Object obj = iter.next();
            sb.append(obj == null ? NULL_OBJECT_PRINTABLE_TEXT : obj.toString());
        }
        if (!first) {
            sb.append(separatorLast);
        }
        return sb;
    }

    public void setConfig(Configuration newConfig, Configuration prevConfig, Configuration.Differences changedKeys) {
        if (changedKeys.contains("org.lockss.soap.")) {
            this.connectionTimeout = newConfig.getTimeInterval("org.lockss.soap.connection.timeout", 10000L);
            this.readTimeout = newConfig.getTimeInterval("org.lockss.soap.read.timeout", 120000L);
            this.repoNamespace = newConfig.get("org.lockss.soap.repository.namespace", DEFAULT_REPO_NAMESPACE);
        }
    }
}

