/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.ws;

import org.lockss.app.LockssApp;
import org.lockss.app.LockssDaemon;
import org.lockss.app.ManagerDescs;
import org.lockss.app.ServiceDescr;
import org.lockss.log.L4JLogger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.solr.SolrAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ImportResource;

@SpringBootApplication(exclude={SolrAutoConfiguration.class})
@ImportResource(value={"classpath:webservice-definition-beans.xml"})
public class SoapApplication
implements CommandLineRunner {
    private static L4JLogger log = L4JLogger.getLogger();
    @Autowired
    private ApplicationContext appCtx;
    private static final LockssApp.ManagerDesc[] myManagerDescs = new LockssApp.ManagerDesc[]{ManagerDescs.ACCOUNT_MANAGER_DESC};

    public static void main(String[] args) {
        log.info("Starting the application");
        SpringApplication.run(SoapApplication.class, (String[])args);
    }

    public void run(String ... args) {
        if (args != null && args.length > 0) {
            log.info("Starting the LOCKSS SOAP Service");
            LockssApp.AppSpec spec = new LockssApp.AppSpec().setService(ServiceDescr.SVC_SOAP).setName("SOAP Service").setArgs(args).addAppConfig("org.lockss.startPlugins", "false").addAppDefault("org.lockss.plugin.startAllAus", "false").setSpringApplicatonContext(this.appCtx).setAppManagers(myManagerDescs);
            LockssApp.startStatic(LockssDaemon.class, (LockssApp.AppSpec)spec);
        }
    }
}

