/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.ws.content;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import org.lockss.app.ServiceDescr;
import org.lockss.log.L4JLogger;
import org.lockss.ws.BaseServiceImpl;
import org.lockss.ws.content.ContentConfigurationService;
import org.lockss.ws.entities.ContentConfigurationResult;
import org.lockss.ws.entities.LockssWebServicesFault;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class ContentConfigurationServiceImpl
extends BaseServiceImpl
implements ContentConfigurationService {
    private static final L4JLogger log = L4JLogger.getLogger();

    public ContentConfigurationResult addAuById(String auId) throws LockssWebServicesFault {
        log.debug2("auId = {}", (Object)auId);
        ArrayList<String> auIds = new ArrayList<String>();
        auIds.add(auId);
        ContentConfigurationResult result = (ContentConfigurationResult)this.addAusByIdList(auIds).get(0);
        log.debug2("result = {}", (Object)result);
        return result;
    }

    public List<ContentConfigurationResult> addAusByIdList(List<String> auIds) throws LockssWebServicesFault {
        log.debug2("auIds = {}", auIds);
        try {
            ResponseEntity response = this.callRestServiceEndpoint(this.getServiceEndpoint(ServiceDescr.SVC_CONFIG), "/aus/add", null, null, HttpMethod.POST, auIds, "Can't add AUs");
            try {
                ObjectMapper mapper = new ObjectMapper();
                List result = (List)mapper.readValue((String)response.getBody(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                log.debug2("result = " + result);
                return result;
            }
            catch (Exception e) {
                log.error("Cannot get body of response", (Throwable)e);
                throw e;
            }
        }
        catch (Exception e) {
            throw new LockssWebServicesFault((Throwable)e);
        }
    }

    public ContentConfigurationResult deleteAuById(String auId) throws LockssWebServicesFault {
        log.debug2("auId = {}", (Object)auId);
        ArrayList<String> auIds = new ArrayList<String>(1);
        auIds.add(auId);
        ContentConfigurationResult result = (ContentConfigurationResult)this.deleteAusByIdList(auIds).get(0);
        log.debug2("result = {}", (Object)result);
        return result;
    }

    public List<ContentConfigurationResult> deleteAusByIdList(List<String> auIds) throws LockssWebServicesFault {
        log.debug2("auIds = {}", auIds);
        try {
            ResponseEntity response = this.callRestServiceEndpoint(this.getServiceEndpoint(ServiceDescr.SVC_CONFIG), "/aus/delete", null, null, HttpMethod.DELETE, auIds, "Can't delete AUs");
            try {
                ObjectMapper mapper = new ObjectMapper();
                List result = (List)mapper.readValue((String)response.getBody(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                log.debug2("result = " + result);
                return result;
            }
            catch (Exception e) {
                log.error("Cannot get body of response", (Throwable)e);
                throw e;
            }
        }
        catch (Exception e) {
            throw new LockssWebServicesFault((Throwable)e);
        }
    }

    public ContentConfigurationResult reactivateAuById(String auId) throws LockssWebServicesFault {
        log.debug2("auId = {}", (Object)auId);
        ArrayList<String> auIds = new ArrayList<String>(1);
        auIds.add(auId);
        ContentConfigurationResult result = (ContentConfigurationResult)this.reactivateAusByIdList(auIds).get(0);
        log.debug2("result = {}", (Object)result);
        return result;
    }

    public List<ContentConfigurationResult> reactivateAusByIdList(List<String> auIds) throws LockssWebServicesFault {
        log.debug2("auIds = {}", auIds);
        try {
            ResponseEntity response = this.callRestServiceEndpoint(this.getServiceEndpoint(ServiceDescr.SVC_CONFIG), "/aus/reactivate", null, null, HttpMethod.PUT, auIds, "Can't reactivate AUs");
            try {
                ObjectMapper mapper = new ObjectMapper();
                List result = (List)mapper.readValue((String)response.getBody(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                log.debug2("result = " + result);
                return result;
            }
            catch (Exception e) {
                log.error("Cannot get body of response", (Throwable)e);
                throw e;
            }
        }
        catch (Exception e) {
            throw new LockssWebServicesFault((Throwable)e);
        }
    }

    public ContentConfigurationResult deactivateAuById(String auId) throws LockssWebServicesFault {
        log.debug2("auId = {}", (Object)auId);
        ArrayList<String> auIds = new ArrayList<String>(1);
        auIds.add(auId);
        ContentConfigurationResult result = (ContentConfigurationResult)this.deactivateAusByIdList(auIds).get(0);
        log.debug2("result = {}", (Object)result);
        return result;
    }

    public List<ContentConfigurationResult> deactivateAusByIdList(List<String> auIds) throws LockssWebServicesFault {
        log.debug2("auIds = {}", auIds);
        try {
            ResponseEntity response = this.callRestServiceEndpoint(this.getServiceEndpoint(ServiceDescr.SVC_CONFIG), "/aus/deactivate", null, null, HttpMethod.PUT, auIds, "Can't deactivate AUs");
            try {
                ObjectMapper mapper = new ObjectMapper();
                List result = (List)mapper.readValue((String)response.getBody(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                log.debug2("result = " + result);
                return result;
            }
            catch (Exception e) {
                log.error("Cannot get body of response", (Throwable)e);
                throw e;
            }
        }
        catch (Exception e) {
            throw new LockssWebServicesFault((Throwable)e);
        }
    }
}

