/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.ws.control;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.lockss.app.ServiceDescr;
import org.lockss.log.L4JLogger;
import org.lockss.util.rest.RestUtil;
import org.lockss.util.rest.config.RestConfigClient;
import org.lockss.util.rest.crawler.CrawlDesc;
import org.lockss.util.rest.crawler.CrawlJob;
import org.lockss.util.rest.crawler.RestCrawlerClient;
import org.lockss.util.rest.exception.LockssRestHttpException;
import org.lockss.util.rest.mdx.MetadataUpdateSpec;
import org.lockss.util.rest.poller.PollDesc;
import org.lockss.util.rest.poller.RestPollerClient;
import org.lockss.ws.BaseServiceImpl;
import org.lockss.ws.control.AuControlService;
import org.lockss.ws.entities.CheckSubstanceResult;
import org.lockss.ws.entities.LockssWebServicesFault;
import org.lockss.ws.entities.RequestAuControlResult;
import org.lockss.ws.entities.RequestCrawlResult;
import org.lockss.ws.entities.RequestDeepCrawlResult;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class AuControlServiceImpl
extends BaseServiceImpl
implements AuControlService {
    static final String MISSING_AU_ID_ERROR_MESSAGE = "Missing auId";
    static final String NO_SUBSTANCE_ERROR_MESSAGE = "No substance patterns defined for plugin";
    static final String NO_SUCH_AU_ERROR_MESSAGE = "No such Archival Unit";
    static final String UNEXPECTED_SUBSTANCE_CHECKER_ERROR_MESSAGE = "Error in SubstanceChecker; see log";
    static final String USE_FORCE_MESSAGE = "Use the 'force' parameter to override.";
    static final String DISABLED_METADATA_PROCESSING_ERROR_MESSAGE = "Metadata processing is not enabled";
    static final String DISABLE_METADATA_INDEXING_ERROR_MESSAGE = "Cannot disable AU metadata indexing";
    static final String ACTION_ENABLE_METADATA_INDEXING = "Enable Indexing";
    static final String ENABLE_METADATA_INDEXING_ERROR_MESSAGE = "Cannot enable AU metadata indexing";
    private static final L4JLogger log = L4JLogger.getLogger();

    public CheckSubstanceResult checkSubstanceById(String auId) throws LockssWebServicesFault {
        log.debug2("auId = {}", (Object)auId);
        try {
            CheckSubstanceResult response = ((RestConfigClient)((RestConfigClient)new RestConfigClient(this.getServiceEndpoint(ServiceDescr.SVC_CONFIG)).setRestTemplate(this.restTemplate)).addRequestHeaders(this.getAuthHeaders())).putAuSubstanceCheck(auId);
            log.debug2("response = {}", (Object)response);
            return response;
        }
        catch (Exception e) {
            throw new LockssWebServicesFault((Throwable)e);
        }
    }

    public List<CheckSubstanceResult> checkSubstanceByIdList(List<String> auIds) throws LockssWebServicesFault {
        log.debug2("auIds = {}", auIds);
        ArrayList<CheckSubstanceResult> results = new ArrayList<CheckSubstanceResult>(auIds.size());
        for (String auId : auIds) {
            results.add(this.checkSubstanceById(auId));
        }
        log.debug2("results = {}", results);
        return results;
    }

    public RequestCrawlResult requestCrawlById(String auId, Integer priority, boolean force) throws LockssWebServicesFault {
        log.debug2("auId = {}, priority = {}, force = {}", (Object)auId, (Object)priority, (Object)force);
        try {
            CrawlDesc crawlDesc = new CrawlDesc();
            crawlDesc.setAuId(auId);
            crawlDesc.setPriority(priority);
            crawlDesc.setForceCrawl(Boolean.valueOf(force));
            try {
                CrawlJob job = ((RestCrawlerClient)((RestCrawlerClient)new RestCrawlerClient(this.getServiceEndpoint(ServiceDescr.SVC_CRAWLER)).addRequestHeaders(this.getAuthHeaders())).setRestTemplate(this.restTemplate)).callCrawl(crawlDesc);
                return new RequestCrawlResult(auId, true, job.getResult(), null);
            }
            catch (LockssRestHttpException e) {
                String msg = e.getMessage();
                if (!e.getHttpStatus().equals((Object)HttpStatus.NOT_FOUND) && e.getCause() != null) {
                    msg = e.getCause().getMessage();
                }
                return new RequestCrawlResult(auId, false, null, msg);
            }
        }
        catch (Exception e) {
            throw new LockssWebServicesFault((Throwable)e);
        }
    }

    public List<RequestCrawlResult> requestCrawlByIdList(List<String> auIds, Integer priority, boolean force) throws LockssWebServicesFault {
        log.debug2("auIds = {}, priority = {}, force = {}", auIds, (Object)priority, (Object)force);
        ArrayList<RequestCrawlResult> results = new ArrayList<RequestCrawlResult>(auIds.size());
        for (String auId : auIds) {
            results.add(this.requestCrawlById(auId, priority, force));
        }
        log.debug2("results = {}", results);
        return results;
    }

    public RequestDeepCrawlResult requestDeepCrawlById(String auId, int refetchDepth, Integer priority, boolean force) throws LockssWebServicesFault {
        log.debug2("auId = {}, refetchDepth = {}, priority = {}, force = {}", (Object)auId, (Object)refetchDepth, (Object)priority, (Object)force);
        try {
            CrawlDesc crawlDesc = new CrawlDesc();
            crawlDesc.setAuId(auId);
            crawlDesc.setRefetchDepth(Integer.valueOf(refetchDepth));
            crawlDesc.setPriority(priority);
            crawlDesc.setForceCrawl(Boolean.valueOf(force));
            try {
                CrawlJob job = ((RestCrawlerClient)((RestCrawlerClient)new RestCrawlerClient(this.getServiceEndpoint(ServiceDescr.SVC_CRAWLER)).addRequestHeaders(this.getAuthHeaders())).setRestTemplate(this.restTemplate)).callCrawl(crawlDesc);
                return new RequestDeepCrawlResult(auId, refetchDepth, true, job.getResult(), null);
            }
            catch (LockssRestHttpException e) {
                String msg = e.getMessage();
                if (!e.getHttpStatus().equals((Object)HttpStatus.NOT_FOUND) && e.getCause() != null) {
                    msg = e.getCause().getMessage();
                }
                return new RequestDeepCrawlResult(auId, refetchDepth, false, null, msg);
            }
        }
        catch (Exception e) {
            throw new LockssWebServicesFault((Throwable)e);
        }
    }

    public List<RequestDeepCrawlResult> requestDeepCrawlByIdList(List<String> auIds, int refetchDepth, Integer priority, boolean force) throws LockssWebServicesFault {
        log.debug2("auIds = {}, refetchDepth = {}, priority = {}, force = {}", auIds, (Object)refetchDepth, (Object)priority, (Object)force);
        ArrayList<RequestDeepCrawlResult> results = new ArrayList<RequestDeepCrawlResult>(auIds.size());
        for (String auId : auIds) {
            results.add(this.requestDeepCrawlById(auId, refetchDepth, priority, force));
        }
        log.debug2("results = {}", results);
        return results;
    }

    public RequestAuControlResult requestPollById(String auId) throws LockssWebServicesFault {
        log.debug2("auId = {}", (Object)auId);
        RequestAuControlResult result = null;
        if (StringUtils.isEmpty((CharSequence)auId)) {
            result = new RequestAuControlResult(auId, false, MISSING_AU_ID_ERROR_MESSAGE);
            log.debug2("result = {}", (Object)result);
            return result;
        }
        String message = null;
        try {
            PollDesc pollDescription = new PollDesc();
            pollDescription.setAuId(auId);
            log.trace("pollDescription = {}", (Object)pollDescription);
            String response = ((RestPollerClient)((RestPollerClient)new RestPollerClient(this.getServiceEndpoint(ServiceDescr.SVC_POLLER)).addRequestHeaders(this.getAuthHeaders())).setRestTemplate(this.restTemplate)).callPoll(pollDescription);
            log.trace("response = {}", (Object)response);
            result = new RequestAuControlResult(response, true, null);
        }
        catch (LockssRestHttpException lrhe) {
            message = lrhe.getMessage();
            log.trace("message = {}", (Object)message);
            if (lrhe.getHttpStatus().equals((Object)HttpStatus.NOT_FOUND)) {
                message = NO_SUCH_AU_ERROR_MESSAGE;
            } else if (lrhe.getCause() != null) {
                message = lrhe.getCause().getMessage();
            }
            result = new RequestAuControlResult(auId, false, message);
        }
        catch (Exception e) {
            message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            result = new RequestAuControlResult(auId, false, message);
        }
        log.debug2("result = {}", (Object)result);
        return result;
    }

    public List<RequestAuControlResult> requestPollByIdList(List<String> auIds) throws LockssWebServicesFault {
        log.debug2("auIds = {}", auIds);
        ArrayList<RequestAuControlResult> results = new ArrayList<RequestAuControlResult>(auIds.size());
        for (String auId : auIds) {
            results.add(this.requestPollById(auId));
        }
        log.debug2("results = {}", results);
        return results;
    }

    public RequestAuControlResult requestMdIndexingById(String auId, boolean force) throws LockssWebServicesFault {
        log.debug2("auId = {}, force = {}", (Object)auId, (Object)force);
        RequestAuControlResult result = null;
        try {
            HashMap<String, String> queryParams = new HashMap<String, String>(1);
            queryParams.put("force", String.valueOf(force));
            log.trace("queryParams = {}", queryParams);
            MetadataUpdateSpec metadataUpdateSpec = new MetadataUpdateSpec();
            metadataUpdateSpec.setAuid(auId);
            metadataUpdateSpec.setUpdateType("full_extraction");
            ResponseEntity response = this.callRestServiceEndpoint(this.getServiceEndpoint(ServiceDescr.SVC_MDX), "/mdupdates", null, queryParams, HttpMethod.POST, (Object)metadataUpdateSpec, "Can't request metadata indexing");
            HttpStatus statusCode = response.getStatusCode();
            log.trace("statusCode = {}", (Object)statusCode);
            result = RestUtil.isSuccess((HttpStatus)statusCode) ? new RequestAuControlResult(auId, true, null) : new RequestAuControlResult(auId, false, statusCode.toString());
            log.debug2("result = {}", (Object)result);
            return result;
        }
        catch (Exception e) {
            throw new LockssWebServicesFault((Throwable)e);
        }
    }

    public List<RequestAuControlResult> requestMdIndexingByIdList(List<String> auIds, boolean force) throws LockssWebServicesFault {
        log.debug2("auIds = {}, force = {}", auIds, (Object)force);
        ArrayList<RequestAuControlResult> results = new ArrayList<RequestAuControlResult>(auIds.size());
        for (String auId : auIds) {
            results.add(this.requestMdIndexingById(auId, force));
        }
        log.debug2("results = {}", results);
        return results;
    }

    public RequestAuControlResult disableMdIndexingById(String auId) throws LockssWebServicesFault {
        log.debug2("auId = {}", (Object)auId);
        try {
            String response = ((RestConfigClient)((RestConfigClient)new RestConfigClient(this.getServiceEndpoint(ServiceDescr.SVC_CONFIG)).addRequestHeaders(this.getAuthHeaders())).setRestTemplate(this.restTemplate)).patchArchivalUnitState(auId, "{\"isMetadataExtractionEnabled\":false}", null);
            log.debug2("response = {}", (Object)response);
            RequestAuControlResult result = new RequestAuControlResult(auId, true, null);
            log.debug2("result = {}", (Object)result);
            return result;
        }
        catch (Exception e) {
            throw new LockssWebServicesFault((Throwable)e);
        }
    }

    public List<RequestAuControlResult> disableMdIndexingByIdList(List<String> auIds) throws LockssWebServicesFault {
        log.debug2("auIds = {}", auIds);
        ArrayList<RequestAuControlResult> results = new ArrayList<RequestAuControlResult>(auIds.size());
        for (String auId : auIds) {
            results.add(this.disableMdIndexingById(auId));
        }
        log.debug2("results = {}", results);
        return results;
    }

    public RequestAuControlResult enableMdIndexingById(String auId) throws LockssWebServicesFault {
        log.debug2("auId = {}", (Object)auId);
        try {
            String response = ((RestConfigClient)((RestConfigClient)new RestConfigClient(this.getServiceEndpoint(ServiceDescr.SVC_CONFIG)).addRequestHeaders(this.getAuthHeaders())).setRestTemplate(this.restTemplate)).patchArchivalUnitState(auId, "{\"isMetadataExtractionEnabled\":true}", null);
            log.debug2("response = {}", (Object)response);
            RequestAuControlResult result = new RequestAuControlResult(auId, true, null);
            log.debug2("result = {}", (Object)result);
            return result;
        }
        catch (Exception e) {
            throw new LockssWebServicesFault((Throwable)e);
        }
    }

    public List<RequestAuControlResult> enableMdIndexingByIdList(List<String> auIds) throws LockssWebServicesFault {
        log.debug2("auIds = {}", auIds);
        ArrayList<RequestAuControlResult> results = new ArrayList<RequestAuControlResult>(auIds.size());
        for (String auId : auIds) {
            results.add(this.enableMdIndexingById(auId));
        }
        log.debug2("results = {}", results);
        return results;
    }
}

