/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.ws.cxf;

import org.apache.cxf.Bus;
import org.apache.cxf.annotations.Provider;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.ext.logging.LoggingInInterceptor;
import org.apache.cxf.ext.logging.LoggingOutInterceptor;
import org.apache.cxf.ext.logging.event.LogEventSender;
import org.apache.cxf.ext.logging.event.PrettyLoggingFilter;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.lockss.ws.cxf.LockssSlf4jEventSender;
import org.lockss.ws.cxf.LockssSlf4jVerboseEventSender;

@NoJSR250Annotations
@Provider(value=Provider.Type.Feature)
public class LockssLoggingFeature
extends AbstractFeature {
    private final LoggingInInterceptor in;
    private final LoggingOutInterceptor out;
    private final PrettyLoggingFilter inPrettyFilter;
    private final PrettyLoggingFilter outPrettyFilter;

    public LockssLoggingFeature() {
        LockssSlf4jVerboseEventSender sender = new LockssSlf4jVerboseEventSender();
        this.inPrettyFilter = new PrettyLoggingFilter((LogEventSender)sender);
        this.outPrettyFilter = new PrettyLoggingFilter((LogEventSender)sender);
        this.setPrettyLogging(true);
        this.in = new LoggingInInterceptor((LogEventSender)this.inPrettyFilter);
        this.out = new LoggingOutInterceptor((LogEventSender)this.outPrettyFilter);
    }

    protected void initializeProvider(InterceptorProvider provider, Bus bus) {
        provider.getInInterceptors().add(this.in);
        provider.getInFaultInterceptors().add(this.in);
        provider.getOutInterceptors().add(this.out);
        provider.getOutFaultInterceptors().add(this.out);
    }

    public void setLimit(int limit) {
        this.in.setLimit(limit);
        this.out.setLimit(limit);
    }

    public void setInMemThreshold(long inMemThreshold) {
        this.in.setInMemThreshold(inMemThreshold);
        this.out.setInMemThreshold(inMemThreshold);
    }

    public void setSender(LogEventSender sender) {
        this.inPrettyFilter.setNext(sender);
        this.outPrettyFilter.setNext(sender);
    }

    public void setInSender(LogEventSender s) {
        this.inPrettyFilter.setNext(s);
    }

    public void setOutSender(LogEventSender s) {
        this.outPrettyFilter.setNext(s);
    }

    public void setPrettyLogging(boolean prettyLogging) {
        this.inPrettyFilter.setPrettyLogging(prettyLogging);
        this.outPrettyFilter.setPrettyLogging(prettyLogging);
    }

    public void setLogBinary(boolean logBinary) {
        this.in.setLogBinary(logBinary);
        this.out.setLogBinary(logBinary);
    }

    public void setLogMultipart(boolean logMultipart) {
        this.in.setLogMultipart(logMultipart);
        this.out.setLogMultipart(logMultipart);
    }

    public void setVerbose(boolean verbose) {
        this.setSender((LogEventSender)(verbose ? new LockssSlf4jVerboseEventSender() : new LockssSlf4jEventSender()));
    }
}

