/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.ws.export;

import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.ws.soap.MTOM;
import org.apache.cxf.attachment.AttachmentDataSource;
import org.lockss.app.ServiceDescr;
import org.lockss.log.L4JLogger;
import org.lockss.util.rest.RestUtil;
import org.lockss.util.rest.SpringHeaderUtil;
import org.lockss.util.rest.multipart.MultipartConnector;
import org.lockss.util.rest.multipart.MultipartResponse;
import org.lockss.ws.BaseServiceImpl;
import org.lockss.ws.entities.DataHandlerWrapper;
import org.lockss.ws.entities.ExportServiceParams;
import org.lockss.ws.entities.ExportServiceWsResult;
import org.lockss.ws.entities.LockssWebServicesFault;
import org.lockss.ws.export.ExportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;

@MTOM
@Service
public class ExportServiceImpl
extends BaseServiceImpl
implements ExportService {
    private static final L4JLogger log = L4JLogger.getLogger();
    @Autowired
    private Environment env;

    public ExportServiceWsResult createExportFiles(ExportServiceParams exportParam) throws LockssWebServicesFault {
        log.debug2("exportParam = {}", (Object)exportParam);
        try {
            String endpointUri = this.getServiceEndpoint(ServiceDescr.SVC_POLLER) + "/aus/{auId}/export";
            log.trace("endpointUri = {}", (Object)endpointUri);
            HashMap<String, String> uriVariables = new HashMap<String, String>(1);
            uriVariables.put("auId", exportParam.getAuid());
            log.trace("uriVariables = {}", uriVariables);
            HashMap<String, String> queryParams = new HashMap<String, String>(1);
            queryParams.put("fileType", exportParam.getFileType().toString());
            queryParams.put("isCompress", exportParam.isCompress() ? "true" : "false");
            queryParams.put("isExcludeDirNodes", exportParam.isExcludeDirNodes() ? "true" : "false");
            queryParams.put("xlateFilenames", exportParam.getXlateFilenames().toString());
            queryParams.put("filePrefix", exportParam.getFilePrefix());
            queryParams.put("maxSize", Long.valueOf(exportParam.getMaxSize()).toString());
            queryParams.put("maxVersions", Integer.valueOf(exportParam.getMaxVersions()).toString());
            log.trace("queryParams = {}", queryParams);
            URI uri = RestUtil.getRestUri((String)endpointUri, uriVariables, queryParams);
            log.trace("uri = {}", (Object)uri);
            HttpHeaders requestHeaders = new HttpHeaders();
            requestHeaders.setAccept(Arrays.asList(MediaType.MULTIPART_FORM_DATA, MediaType.APPLICATION_JSON));
            SpringHeaderUtil.addHeaders((HttpHeaders)this.getAuthHeaders(), (HttpHeaders)requestHeaders);
            log.trace("requestHeaders = {}", (Object)requestHeaders);
            MultipartResponse response = new MultipartConnector(uri, requestHeaders).setRestTemplate(this.restTemplate).requestGet((long)this.getConnectionTimeout().intValue(), (long)this.getReadTimeout().intValue());
            HttpStatus statusCode = response.getStatusCode();
            log.trace("statusCode = " + statusCode);
            if (statusCode.equals((Object)HttpStatus.OK)) {
                LinkedHashMap parts = response.getParts();
                log.trace("parts = " + parts);
                int partCount = parts.size();
                log.trace("partCount = " + partCount);
                DataHandlerWrapper[] dataHandlerWrapperArray = new DataHandlerWrapper[partCount];
                int partIndex = 0;
                for (String name : parts.keySet()) {
                    log.trace("name = " + name);
                    MultipartResponse.Part part = (MultipartResponse.Part)parts.get(name);
                    log.trace("part = " + part);
                    String contentType = part.getHeaders().getFirst("Content-Type");
                    log.trace("contentType = " + contentType);
                    AttachmentDataSource source = new AttachmentDataSource(contentType, part.getInputStream());
                    log.trace("source = " + source);
                    source.setName(name);
                    DataHandler dataHandler = new DataHandler((DataSource)source);
                    long size = part.getContentLength();
                    log.trace("size = " + size);
                    DataHandlerWrapper dataHandlerWrapper = new DataHandlerWrapper();
                    dataHandlerWrapper.setDataHandler(dataHandler);
                    dataHandlerWrapper.setSize(size);
                    dataHandlerWrapper.setName(source.getName());
                    dataHandlerWrapperArray[partIndex++] = dataHandlerWrapper;
                }
                ExportServiceWsResult result = new ExportServiceWsResult();
                result.setDataHandlerWrappers(dataHandlerWrapperArray);
                result.setAuId(exportParam.getAuid());
                log.debug2("result = {}", (Object)result);
                return result;
            }
            String message = "REST service returned statusCode '" + statusCode + ", statusMessage = '" + response.getStatusMessage() + "'";
            log.error(message);
            throw new RuntimeException(message);
        }
        catch (Exception e) {
            throw new LockssWebServicesFault((Throwable)e);
        }
    }
}

