/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.ws.importer;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.IOUtils;
import org.lockss.app.ServiceDescr;
import org.lockss.log.L4JLogger;
import org.lockss.util.PropertiesUtil;
import org.lockss.util.io.DeferredTempFileOutputStream;
import org.lockss.util.rest.HttpResponseStatusAndHeaders;
import org.lockss.util.rest.RestUtil;
import org.lockss.util.rest.SpringHeaderUtil;
import org.lockss.util.rest.multipart.MultipartConnector;
import org.lockss.util.rest.repo.util.NamedInputStreamResource;
import org.lockss.ws.BaseServiceImpl;
import org.lockss.ws.entities.ImportWsParams;
import org.lockss.ws.entities.ImportWsResult;
import org.lockss.ws.entities.LockssWebServicesFault;
import org.lockss.ws.importer.ImportService;
import org.lockss.ws.importer.ImportServiceImpl;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StreamUtils;

@Service
public class ImportServiceImpl
extends BaseServiceImpl
implements ImportService {
    private static final L4JLogger log = L4JLogger.getLogger();
    private static final String IMPORT_CONTENT_PART_NAME = "file";
    private static final String BASIC_AUTH_KEY = "BasicAuthorization";

    public ImportWsResult importPulledFile(ImportWsParams importParams) throws LockssWebServicesFault {
        log.debug2("importParams = {}", (Object)importParams);
        ImportWsResult wsResult = new ImportWsResult();
        try {
            URI uri = this.getImportEndpointUri();
            log.trace("uri = {}", (Object)uri);
            String[] userProperties = importParams.getProperties();
            log.trace("userProperties = {}", Arrays.asList(userProperties));
            HttpInputMessage src = (HttpInputMessage)this.restTemplate.execute(importParams.getSourceUrl(), HttpMethod.GET, null, response -> {
                try (DeferredTempFileOutputStream dfos = new DeferredTempFileOutputStream(0x100000, "importSourceUrl");){
                    StreamUtils.copy((InputStream)response.getBody(), (OutputStream)dfos);
                    1 var4_4 = new /* Unavailable Anonymous Inner Class!! */;
                    return var4_4;
                }
            }, PropertiesUtil.convertArrayToMap((String[])userProperties));
            wsResult = this.performRestCall(importParams.getTargetId(), importParams.getTargetUrl(), userProperties, src.getBody(), uri, src.getHeaders().getContentType().toString(), src.getHeaders().getContentLength());
        }
        catch (Exception e) {
            wsResult.setIsSuccess(Boolean.FALSE);
            wsResult.setMessage("Cannot import pushed content: " + e.getMessage());
        }
        log.debug2("wsResult = {}", (Object)wsResult);
        return wsResult;
    }

    public ImportWsResult importPushedFile(ImportWsParams importParams) throws LockssWebServicesFault {
        log.debug2("importParams = {}", (Object)importParams);
        ImportWsResult wsResult = new ImportWsResult();
        URI uri = this.getImportEndpointUri();
        log.trace("uri = {}", (Object)uri);
        DataHandler dataHandler = importParams.getDataHandler();
        try (InputStream in = dataHandler.getInputStream();){
            try (DeferredTempFileOutputStream dfos = new DeferredTempFileOutputStream(131072);){
                IOUtils.copyLarge((InputStream)in, (OutputStream)dfos);
                wsResult = this.performRestCall(importParams.getTargetId(), importParams.getTargetUrl(), importParams.getProperties(), dfos.getDeleteOnCloseInputStream(), uri, dataHandler.getContentType(), dfos.getByteCount());
            }
            catch (Exception e) {
                wsResult.setIsSuccess(Boolean.FALSE);
                wsResult.setMessage("Cannot import pushed content: " + e.getMessage());
            }
        }
        catch (IOException ioe) {
            wsResult.setIsSuccess(Boolean.FALSE);
            wsResult.setMessage("Cannot open input stream to pushed content: " + ioe.getMessage());
            log.debug2("wsResult = {}", (Object)wsResult);
            return wsResult;
        }
        log.debug2("wsResult = {}", (Object)wsResult);
        return wsResult;
    }

    public String[] getSupportedChecksumAlgorithms() throws LockssWebServicesFault {
        log.debug2("Invoked.");
        try {
            ResponseEntity response = this.callRestServiceEndpoint(this.getServiceEndpoint(ServiceDescr.SVC_REPO), "/checksumalgorithms", null, null, HttpMethod.GET, (Object)null, "Can't get supported checksum algorithms");
            try {
                ObjectMapper mapper = new ObjectMapper();
                List list = (List)mapper.readValue((String)response.getBody(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                log.trace("list = {}", (Object)list);
                Object[] result = list.toArray(new String[0]);
                log.debug2("result = {}", (Object)Arrays.toString(result));
                return result;
            }
            catch (Exception e) {
                log.error("Cannot get body of response", (Throwable)e);
                throw e;
            }
        }
        catch (Exception e) {
            throw new LockssWebServicesFault((Throwable)e);
        }
    }

    private URI getImportEndpointUri() {
        log.debug2("Invoked");
        String endpointUri = this.getServiceEndpoint(ServiceDescr.SVC_POLLER) + "/ws/aus/import";
        log.trace("endpointUri = {}", (Object)endpointUri);
        URI uri = RestUtil.getRestUri((String)endpointUri, null, null);
        log.debug2("uri = {}", (Object)uri);
        return uri;
    }

    private URLConnection getSourceUrlConnection(String sourceUrl, Map<String, String> properties) throws MalformedURLException, IOException {
        log.debug2("sourceUrl = {}", (Object)sourceUrl);
        log.debug2("properties = {}", properties);
        URL url = new URL(sourceUrl);
        URLConnection urlConnection = url.openConnection();
        String uInfo = url.getUserInfo();
        log.trace("uInfo = {}", (Object)uInfo);
        if (uInfo != null) {
            String basicAuth = "Basic " + DatatypeConverter.printBase64Binary((byte[])uInfo.getBytes());
            log.trace("basicAuth = {}", (Object)basicAuth);
            urlConnection.setRequestProperty("Authorization", basicAuth);
        } else if (properties.containsKey(BASIC_AUTH_KEY)) {
            String basicAuth = properties.get(BASIC_AUTH_KEY);
            log.trace("basicAuth = {}", (Object)basicAuth);
            urlConnection.setRequestProperty("Authorization", basicAuth);
        }
        log.debug2("urlConnection = {}", (Object)urlConnection);
        return urlConnection;
    }

    private ImportWsResult performRestCall(String targetId, String targetUrl, String[] userProperties, InputStream input, URI uri, String contentType, long contentLength) {
        log.debug2("targetId = {}", (Object)targetId);
        log.debug2("targetUrl = {}", (Object)targetUrl);
        log.debug2("userProperties = {}", Arrays.asList(userProperties));
        log.debug2("uri = {}", (Object)uri);
        log.debug2("contentType = {}", (Object)contentType);
        log.debug2("contentLength = {}", (Object)contentLength);
        HttpHeaders requestHeaders = new HttpHeaders();
        requestHeaders.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        requestHeaders.setContentType(MediaType.MULTIPART_FORM_DATA);
        SpringHeaderUtil.addHeaders((HttpHeaders)this.getAuthHeaders(), (HttpHeaders)requestHeaders);
        log.trace("requestHeaders = {}", (Object)requestHeaders);
        LinkedMultiValueMap parts = new LinkedMultiValueMap();
        parts.add((Object)"targetBaseUrlPath", (Object)targetId);
        parts.add((Object)"targetUrl", (Object)targetUrl);
        parts.add((Object)"userProperties", (Object)userProperties);
        NamedInputStreamResource resource = new NamedInputStreamResource(IMPORT_CONTENT_PART_NAME, input);
        HttpHeaders partHeaders = new HttpHeaders();
        partHeaders.setContentType(MediaType.valueOf((String)contentType));
        partHeaders.setContentLength(contentLength);
        log.trace("partHeaders = {}", (Object)partHeaders);
        parts.add((Object)IMPORT_CONTENT_PART_NAME, (Object)new HttpEntity((Object)resource, (MultiValueMap)partHeaders));
        log.trace("parts = {}", (Object)parts);
        HttpResponseStatusAndHeaders response = new MultipartConnector(uri, requestHeaders, (MultiValueMap)parts).setRestTemplate(this.restTemplate).requestPut((long)this.getConnectionTimeout().intValue(), (long)this.getReadTimeout().intValue());
        log.trace("response = {}", (Object)response);
        boolean isSuccess = response.getCode() == HttpStatus.OK.value();
        log.trace("isSuccess = {}", (Object)isSuccess);
        ImportWsResult wsResult = new ImportWsResult();
        wsResult.setIsSuccess(Boolean.valueOf(isSuccess));
        if (!isSuccess) {
            wsResult.setMessage(response.getMessage());
        }
        log.debug2("wsResult = {}", (Object)wsResult);
        return wsResult;
    }
}

