/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.lockss.tdb.TdbXml;

@Mojo(name="tdbxml", requiresDependencyResolution=ResolutionScope.TEST)
public class TdbXmlMojo
extends AbstractMojo {
    @Parameter(property="skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="srcDir")
    private File srcDir;
    @Parameter(property="dstDir")
    private File dstDir;
    @Parameter(property="recurse", defaultValue="true")
    private boolean recurse;
    @Parameter(property="throwOnFail", defaultValue="true")
    private boolean throwOnFail;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    private String classpath;

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void setSrcDir(File srcDir) {
        this.srcDir = srcDir;
    }

    public void setDstDir(File dstDir) {
        this.dstDir = dstDir;
    }

    public void setRecurse(boolean recurse) {
        this.recurse = recurse;
    }

    public void setThrowOnFail(boolean throwOnFail) {
        this.throwOnFail = throwOnFail;
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping lockss-tdbxml-maven-plugin per configuration");
            return;
        }
        try {
            this.classpath = String.join((CharSequence)":", this.project.getTestClasspathElements());
            this.getLog().debug((CharSequence)("Classpath: " + this.classpath));
        }
        catch (DependencyResolutionRequiredException exc) {
            throw new MojoExecutionException("Error while determining the classpath elements", (Exception)((Object)exc));
        }
        this.checkDirs();
        Path startPath = this.srcDir.toPath();
        HashMap<File, File> convMap = new HashMap<File, File>();
        EnumSet<FileVisitOption> opts = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
        int depth = 1;
        if (this.recurse) {
            depth = Integer.MAX_VALUE;
        }
        TdbFindFile finder = new TdbFindFile(this.srcDir, this.dstDir, convMap, this.getLog());
        try {
            this.getLog().info((CharSequence)"Starting tree walk...");
            Files.walkFileTree(startPath, opts, depth, finder);
        }
        catch (IOException exc) {
            throw new MojoExecutionException("Unable to walk source tree: " + exc.getMessage(), (Exception)exc);
        }
        this.getLog().info((CharSequence)String.format("Found %d TDB files", convMap.size()));
        if (!convMap.isEmpty()) {
            this.execJavaCmd(convMap);
        }
    }

    public void checkDirs() throws MojoExecutionException {
        if (this.srcDir == null || !this.srcDir.exists() || !this.srcDir.canRead()) {
            throw new MojoExecutionException("Invalid srcDir value: " + this.srcDir);
        }
        if (this.dstDir == null || !this.dstDir.exists() && !this.dstDir.mkdirs()) {
            throw new MojoExecutionException("Invalid dstDir value: " + this.dstDir);
        }
    }

    public void checkOutDir(File dir) throws MojoExecutionException {
        if (dir == null || !dir.exists() && !dir.mkdirs()) {
            throw new MojoExecutionException("Can't create output dir: " + dir);
        }
    }

    public void execJavaCmd(Map<File, File> mapFiles) throws MojoExecutionException {
        if (this.recurse) {
            int convCount = 0;
            for (Map.Entry<File, File> tofro : mapFiles.entrySet()) {
                ArrayList<String> args = new ArrayList<String>();
                File srcFile = tofro.getKey();
                File dstFile = tofro.getValue();
                this.checkOutDir(dstFile.getParentFile());
                if (this.isOutOfDate(srcFile, dstFile)) {
                    this.getLog().debug((CharSequence)String.format("Converting %s => %s", srcFile.getAbsolutePath(), dstFile.getAbsoluteFile()));
                    args.add("-A");
                    args.add("-i");
                    args.add(srcFile.getAbsolutePath());
                    args.add("-o");
                    args.add(dstFile.getAbsolutePath());
                    if (this.runProcess(args) != 0 && this.throwOnFail) {
                        throw new MojoExecutionException("Conversion failed");
                    }
                    ++convCount;
                    continue;
                }
                this.getLog().debug((CharSequence)String.format("Skipping %s => %s", srcFile.getAbsolutePath(), dstFile.getAbsoluteFile()));
            }
            this.getLog().info((CharSequence)String.format("Converted %d TDB files", convCount));
        } else {
            ArrayList<String> args = new ArrayList<String>();
            args.add("--all");
            args.add("--output-dir=" + this.dstDir);
            for (File file : mapFiles.keySet()) {
                args.add(file.getAbsolutePath());
            }
            if (this.runProcess(args) != 0 && this.throwOnFail) {
                throw new MojoExecutionException("Conversion failed");
            }
            this.getLog().info((CharSequence)"Converted all TDB files");
        }
    }

    private int runProcess(List<String> args) throws MojoExecutionException {
        try {
            new TdbXml().run(args.toArray(new String[0]));
            return 0;
        }
        catch (Exception exc) {
            this.getLog().error((CharSequence)"TdbXml invocation threw", (Throwable)exc);
            return 1;
        }
    }

    private boolean isOutOfDate(File srcFile, File dstFile) {
        if (!dstFile.exists()) {
            return true;
        }
        Date srcModified = new Date(srcFile.lastModified());
        Date destModified = new Date(dstFile.lastModified());
        return srcModified.after(destModified);
    }

    static final class TdbFindFile
    extends SimpleFileVisitor<Path> {
        private final PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:*.tdb");
        private final Log logger;
        private final String src;
        private final String dst;
        Map<File, File> resMap;

        TdbFindFile(File src, File dst, Map<File, File> resMap, Log log) {
            this.logger = log;
            this.src = src.getPath();
            this.dst = dst.getPath();
            this.resMap = resMap;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            this.process(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            if (this.logger != null) {
                this.logger.error((Throwable)exc);
            }
            return FileVisitResult.CONTINUE;
        }

        void process(Path file) {
            Path name = file.getFileName();
            if (name != null && this.matcher.matches(name)) {
                File tdb = file.toFile();
                File xml = new File(tdb.getPath().replaceFirst(this.src, this.dst).replace(".tdb", ".xml"));
                this.resMap.put(tdb, xml);
            }
        }
    }
}

