/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public class CollectionUtil2 {
    protected static <T, C extends Collection<T>> C collection(Supplier<C> funcEmptyCollection, T ... elements) {
        Collection ret = (Collection)funcEmptyCollection.get();
        if (elements != null) {
            Collections.addAll(ret, elements);
        }
        return (C)ret;
    }

    protected static <T, C extends Collection<T>> C immutableCollectionOfType(IntFunction<C> funcEmptyCollectionOfSize, UnaryOperator<C> funcImmutableCollection, Collection<?> coll, Class<T> type, boolean nullOk) {
        Collection ret = (Collection)funcEmptyCollectionOfSize.apply(coll.size());
        for (Object element : coll) {
            if (element == null) {
                if (!nullOk) {
                    throw new NullPointerException("Null elements not allowed");
                }
            } else if (!type.isInstance(element)) {
                throw new ClassCastException(String.format("Element not of type %s: %s", type.getName(), element.getClass().getName()));
            }
            ret.add(type.cast(element));
        }
        return (C)((Collection)funcImmutableCollection.apply(ret));
    }

    protected static <T, C extends Collection<T>> C fromIterator(Supplier<C> funcEmptyCollection, Iterator<T> iterator) {
        Collection ret = (Collection)funcEmptyCollection.get();
        while (iterator.hasNext()) {
            ret.add(iterator.next());
        }
        return (C)ret;
    }

    protected static <T, C extends Collection<T>> C fromIterable(Supplier<C> funcEmptyCollection, Iterable<T> iterable) {
        Collection ret = (Collection)funcEmptyCollection.get();
        if (iterable != null) {
            for (T element : iterable) {
                ret.add(element);
            }
        }
        return (C)ret;
    }

    protected static <C extends Collection<String>> C fromCsvStringTokenizer(Supplier<C> funcEmptyCollection, String csv) {
        Collection ret = (Collection)funcEmptyCollection.get();
        StringTokenizer st = new StringTokenizer(csv, ",");
        while (st.hasMoreTokens()) {
            ret.add(st.nextToken());
        }
        return (C)ret;
    }
}

