/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.lockss.util.CollectionUtil2;

public class ListUtil {
    private ListUtil() {
    }

    public static <T> List<T> list(T ... elements) {
        return CollectionUtil2.collection(ArrayList::new, elements);
    }

    public static <T> List<T> append(List<T> ... lists) {
        ArrayList<T> ret = new ArrayList<T>();
        if (lists != null) {
            for (List<T> list : lists) {
                if (list == null) continue;
                ret.addAll(list);
            }
        }
        return ret;
    }

    @Deprecated
    public static <T> List<T> fromArray(T[] array) {
        return ListUtil.list(array);
    }

    public static <T> LinkedList<T> prependAll(List<T> ofList, LinkedList<T> toList) {
        if (toList == null) {
            return ofList == null ? new LinkedList() : new LinkedList<T>(ofList);
        }
        if (ofList == null) {
            return toList;
        }
        List<T> revOfList = ListUtil.reverseCopy(ofList);
        for (T item : revOfList) {
            toList.addFirst(item);
        }
        return toList;
    }

    public static <T> ArrayList<T> minimalArrayList(List<T> lst) {
        if (lst instanceof ArrayList) {
            ArrayList alst = (ArrayList)lst;
            alst.trimToSize();
            return alst;
        }
        return new ArrayList<T>(lst);
    }

    public static <T> List<T> fromIterator(Iterator<T> iterator) {
        return CollectionUtil2.fromIterator(ArrayList::new, iterator);
    }

    public static <T> List<T> fromIterable(Iterable<T> iterable) {
        return CollectionUtil2.fromIterable(ArrayList::new, iterable);
    }

    public static List<String> fromCSV(String csv) {
        return CollectionUtil2.fromCsvStringTokenizer(ArrayList::new, csv);
    }

    public static <T> List<T> immutableListOfType(List<?> list, Class<T> type) {
        return ListUtil.immutableListOfType(list, type, false);
    }

    public static <T> List<T> immutableListOfTypeOrNull(List<?> list, Class<T> type) {
        return ListUtil.immutableListOfType(list, type, true);
    }

    protected static <T> List<T> immutableListOfType(List<?> list, Class<T> type, boolean nullOk) {
        return CollectionUtil2.immutableCollectionOfType(ArrayList::new, Collections::unmodifiableList, list, type, nullOk);
    }

    public static <T> List<T> reverseCopy(List<T> list) {
        ArrayList<T> ret = new ArrayList<T>(list);
        Collections.reverse(ret);
        return ret;
    }
}

