/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.lockss.util.CollectionUtil2;

public class SetUtil {
    private SetUtil() {
    }

    public static <T> Set<T> set(T ... elements) {
        return CollectionUtil2.collection(HashSet::new, elements);
    }

    public static <T> Set<T> immutableSetOfType(Set<?> set, Class<T> type) {
        return SetUtil.immutableSetOfType(set, type, false);
    }

    public static <T> Set<T> immutableSetOfTypeOrNull(Set<?> set, Class<T> type) {
        return SetUtil.immutableSetOfType(set, type, true);
    }

    private static <T> Set<T> immutableSetOfType(Set<?> set, Class<T> type, boolean nullOk) {
        return CollectionUtil2.immutableCollectionOfType(HashSet::new, Collections::unmodifiableSet, set, type, nullOk);
    }

    @Deprecated
    public static <T> Set<T> fromArray(T[] array) {
        return SetUtil.set(array);
    }

    public static <T> Set<T> theSet(Collection<T> coll) {
        return new HashSet<T>(coll);
    }

    public static <T> Set<T> fromList(List<T> list) {
        return SetUtil.theSet(list);
    }

    public static <T> Set<T> fromIterator(Iterator<T> iterator) {
        return CollectionUtil2.fromIterator(HashSet::new, iterator);
    }

    public static <T> Set<T> fromIterable(Iterable<T> iterable) {
        return SetUtil.fromIterator(iterable.iterator());
    }

    public static Set<String> fromCSV(String csv) {
        return CollectionUtil2.fromCsvStringTokenizer(HashSet::new, csv);
    }
}

