/*
 * Decompiled with CFR 0.152.
 */
package org.lockss.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.iterators.ArrayIterator;

public class MapUtil {
    private MapUtil() {
    }

    public static <K, V> Map<K, V> map(Object ... elements) {
        return MapUtil.map(Object.class, Object.class, elements);
    }

    public static <K, V> Map<K, V> map(Class<K> keyType, Class<V> valueType, Object ... elements) {
        if (elements.length % 2 != 0) {
            throw new IllegalArgumentException("Even number of arguments required");
        }
        SequentialKeyValuePairIterator<K, V> iter = new SequentialKeyValuePairIterator<K, V>(keyType, valueType, (Iterator<?>)new ArrayIterator((Object)elements));
        HashMap map = new HashMap();
        while (iter.hasNextKeyValuePair()) {
            map.put(((KeyValuePairIterator)iter).nextKey(), ((KeyValuePairIterator)iter).nextValue());
        }
        return map;
    }

    public static <K, V> Map<K, V> fromList(List<?> keyValuePairs) {
        return MapUtil.fromList(Object.class, Object.class, keyValuePairs);
    }

    public static <K, V> Map<K, V> fromList(Class<K> keyType, Class<V> valueType, List<?> keyValuePairs) {
        KeyValuePairIterator iter;
        HashMap map = new HashMap();
        if (keyValuePairs.isEmpty()) {
            return map;
        }
        KeyValuePairIterator keyValuePairIterator = iter = keyValuePairs.get(0) instanceof List ? new ListOfListsKeyValuePairIterator<K, V>(keyType, valueType, keyValuePairs.iterator()) : new SequentialKeyValuePairIterator<K, V>(keyType, valueType, keyValuePairs.iterator());
        while (iter.hasNextKeyValuePair()) {
            map.put(iter.nextKey(), iter.nextValue());
        }
        return map;
    }

    public static <V> Map<String, V> expandAlternativeKeyLists(Map<String, V> map) {
        HashMap<String, V> res = new HashMap<String, V>();
        for (Map.Entry<String, V> ent : map.entrySet()) {
            String multiKey = ent.getKey();
            V val = ent.getValue();
            for (String key : multiKey.split(";")) {
                String trimmed = key.trim();
                if (trimmed.length() <= 0) continue;
                res.put(key.trim(), val);
            }
        }
        return res;
    }

    protected static class ListOfListsKeyValuePairIterator<K, V>
    extends KeyValuePairIterator<K, V> {
        protected List<?> sub;

        public ListOfListsKeyValuePairIterator(Class<K> keyType, Class<V> valueType, Iterator<?> iterator) {
            super(keyType, valueType, iterator);
        }

        @Override
        public K nextKey() {
            this.sub = (List)this.iterator.next();
            if (this.sub.size() != 2) {
                throw new IllegalArgumentException("Sublist is not of size 2");
            }
            return (K)this.keyType.cast(this.sub.get(0));
        }

        @Override
        public V nextValue() {
            return (V)this.valueType.cast(this.sub.get(1));
        }
    }

    protected static class SequentialKeyValuePairIterator<K, V>
    extends KeyValuePairIterator<K, V> {
        public SequentialKeyValuePairIterator(Class<K> keyType, Class<V> valueType, Iterator<?> iterator) {
            super(keyType, valueType, iterator);
        }

        @Override
        public K nextKey() {
            return (K)this.keyType.cast(this.iterator.next());
        }

        @Override
        public V nextValue() {
            try {
                return (V)this.valueType.cast(this.iterator.next());
            }
            catch (NoSuchElementException nsee) {
                throw new IllegalArgumentException("Even number of arguments required");
            }
        }
    }

    protected static abstract class KeyValuePairIterator<K, V> {
        protected Class<K> keyType;
        protected Class<V> valueType;
        protected Iterator<?> iterator;

        public KeyValuePairIterator(Class<K> keyType, Class<V> valueType, Iterator<?> iterator) {
            this.keyType = keyType;
            this.valueType = valueType;
            this.iterator = iterator;
        }

        public boolean hasNextKeyValuePair() {
            return this.iterator.hasNext();
        }

        public abstract K nextKey();

        public abstract V nextValue();
    }
}

