/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.serviceprovider;

import com.lyncode.xoai.model.oaipmh.Header;
import com.lyncode.xoai.model.oaipmh.Identify;
import com.lyncode.xoai.model.oaipmh.MetadataFormat;
import com.lyncode.xoai.model.oaipmh.Record;
import com.lyncode.xoai.model.oaipmh.Set;
import com.lyncode.xoai.serviceprovider.exceptions.BadArgumentException;
import com.lyncode.xoai.serviceprovider.exceptions.CannotDisseminateFormatException;
import com.lyncode.xoai.serviceprovider.exceptions.EncapsulatedKnownException;
import com.lyncode.xoai.serviceprovider.exceptions.HarvestException;
import com.lyncode.xoai.serviceprovider.exceptions.IdDoesNotExistException;
import com.lyncode.xoai.serviceprovider.exceptions.NoSetHierarchyException;
import com.lyncode.xoai.serviceprovider.handler.GetRecordHandler;
import com.lyncode.xoai.serviceprovider.handler.IdentifyHandler;
import com.lyncode.xoai.serviceprovider.handler.ListIdentifierHandler;
import com.lyncode.xoai.serviceprovider.handler.ListMetadataFormatsHandler;
import com.lyncode.xoai.serviceprovider.handler.ListRecordHandler;
import com.lyncode.xoai.serviceprovider.handler.ListSetsHandler;
import com.lyncode.xoai.serviceprovider.lazy.ItemIterator;
import com.lyncode.xoai.serviceprovider.model.Context;
import com.lyncode.xoai.serviceprovider.parameters.GetRecordParameters;
import com.lyncode.xoai.serviceprovider.parameters.ListIdentifiersParameters;
import com.lyncode.xoai.serviceprovider.parameters.ListMetadataParameters;
import com.lyncode.xoai.serviceprovider.parameters.ListRecordsParameters;
import java.util.Iterator;

public class ServiceProvider {
    private Context context;
    private ListMetadataFormatsHandler listMetadataFormatsHandler;
    private IdentifyHandler identifyHandler;
    private GetRecordHandler getRecordHandler;

    public ServiceProvider(Context context) {
        this.context = context;
        this.identifyHandler = new IdentifyHandler(context);
        this.listMetadataFormatsHandler = new ListMetadataFormatsHandler(context);
        this.getRecordHandler = new GetRecordHandler(context);
    }

    public Identify identify() {
        return this.identifyHandler.handle();
    }

    public Iterator<MetadataFormat> listMetadataFormats() {
        return this.listMetadataFormatsHandler.handle(ListMetadataParameters.request()).iterator();
    }

    public Iterator<MetadataFormat> listMetadataFormats(ListMetadataParameters parameters) {
        return this.listMetadataFormatsHandler.handle(parameters).iterator();
    }

    public Record getRecord(GetRecordParameters parameters) throws BadArgumentException, IdDoesNotExistException, CannotDisseminateFormatException {
        if (!parameters.areValid()) {
            throw new BadArgumentException("GetRecord verb requires identifier and metadataPrefix parameters");
        }
        return this.getRecordHandler.handle(parameters);
    }

    public Iterator<Record> listRecords(ListRecordsParameters parameters) throws BadArgumentException {
        if (!parameters.areValid()) {
            throw new BadArgumentException("ListRecords verb requires the metadataPrefix");
        }
        return new ItemIterator<Record>(new ListRecordHandler(this.context, parameters));
    }

    public Iterator<Header> listIdentifiers(ListIdentifiersParameters parameters) throws BadArgumentException {
        if (!parameters.areValid()) {
            throw new BadArgumentException("ListIdentifiers verb requires the metadataPrefix");
        }
        return new ItemIterator<Header>(new ListIdentifierHandler(this.context, parameters));
    }

    public Iterator<Set> listSets() throws NoSetHierarchyException {
        try {
            return new ItemIterator<Set>(new ListSetsHandler(this.context));
        }
        catch (EncapsulatedKnownException ex) {
            throw this.get(ex, NoSetHierarchyException.class);
        }
    }

    private <T extends HarvestException> boolean instanceOf(EncapsulatedKnownException exception, Class<T> exceptionClass) {
        return exceptionClass.isInstance(exception.getCause());
    }

    private <T extends HarvestException> T get(EncapsulatedKnownException ex, Class<T> exceptionClass) {
        if (this.instanceOf(ex, exceptionClass)) {
            return (T)((HarvestException)ex.getCause());
        }
        return null;
    }
}

