/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.serviceprovider.client;

import com.lyncode.xoai.serviceprovider.client.OAIClient;
import com.lyncode.xoai.serviceprovider.exceptions.HttpException;
import com.lyncode.xoai.serviceprovider.parameters.Parameters;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

public class HttpOAIClient
implements OAIClient {
    private String baseUrl;
    private HttpClient httpclient = new DefaultHttpClient();

    public HttpOAIClient(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    public InputStream execute(Parameters parameters) throws HttpException {
        try {
            HttpResponse response = this.httpclient.execute(this.createGetRequest(parameters));
            if (response.getStatusLine().getStatusCode() == 200) {
                return response.getEntity().getContent();
            }
            throw new HttpException("Error querying service. Returned HTTP Status Code: " + response.getStatusLine().getStatusCode());
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
    }

    private HttpUriRequest createGetRequest(Parameters parameters) {
        return new HttpGet(parameters.toUrl(this.baseUrl));
    }
}

