/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.serviceprovider.handler;

import com.lyncode.xoai.model.oaipmh.Record;
import com.lyncode.xoai.model.oaipmh.Verb;
import com.lyncode.xoai.serviceprovider.client.OAIClient;
import com.lyncode.xoai.serviceprovider.exceptions.CannotDisseminateFormatException;
import com.lyncode.xoai.serviceprovider.exceptions.IdDoesNotExistException;
import com.lyncode.xoai.serviceprovider.exceptions.InvalidOAIResponse;
import com.lyncode.xoai.serviceprovider.exceptions.OAIRequestException;
import com.lyncode.xoai.serviceprovider.model.Context;
import com.lyncode.xoai.serviceprovider.parameters.GetRecordParameters;
import com.lyncode.xoai.serviceprovider.parameters.Parameters;
import com.lyncode.xoai.serviceprovider.parsers.GetRecordParser;

public class GetRecordHandler {
    private final OAIClient client;
    private Context context;

    public GetRecordHandler(Context context) {
        this.context = context;
        this.client = context.getClient();
    }

    public Record handle(GetRecordParameters parameters) throws IdDoesNotExistException, CannotDisseminateFormatException {
        try {
            return new GetRecordParser(this.client.execute(Parameters.parameters().withVerb(Verb.Type.GetRecord).include(parameters)), this.context, parameters.getMetadataPrefix()).parse();
        }
        catch (OAIRequestException e) {
            throw new InvalidOAIResponse(e);
        }
    }
}

