/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.serviceprovider.handler;

import com.lyncode.xml.XmlReader;
import com.lyncode.xml.exceptions.XmlReaderException;
import com.lyncode.xml.matchers.QNameMatchers;
import com.lyncode.xml.matchers.XmlEventMatchers;
import com.lyncode.xoai.model.oaipmh.Header;
import com.lyncode.xoai.model.oaipmh.Verb;
import com.lyncode.xoai.serviceprovider.client.OAIClient;
import com.lyncode.xoai.serviceprovider.exceptions.InvalidOAIResponse;
import com.lyncode.xoai.serviceprovider.exceptions.OAIRequestException;
import com.lyncode.xoai.serviceprovider.lazy.Source;
import com.lyncode.xoai.serviceprovider.model.Context;
import com.lyncode.xoai.serviceprovider.parameters.ListIdentifiersParameters;
import com.lyncode.xoai.serviceprovider.parameters.Parameters;
import com.lyncode.xoai.serviceprovider.parsers.ListIdentifiersParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.events.XMLEvent;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.AllOf;

public class ListIdentifierHandler
implements Source<Header> {
    private Context context;
    private ListIdentifiersParameters parameters;
    private OAIClient client;
    private String resumptionToken;
    private boolean ended = false;

    public ListIdentifierHandler(Context context, ListIdentifiersParameters parameters) {
        this.context = context;
        this.parameters = parameters;
        this.client = context.getClient();
    }

    @Override
    public List<Header> nextIteration() {
        ArrayList<Header> headers = new ArrayList<Header>();
        try {
            InputStream stream = null;
            stream = this.resumptionToken == null ? this.client.execute(Parameters.parameters().withVerb(Verb.Type.ListIdentifiers).include(this.parameters)) : this.client.execute(Parameters.parameters().withVerb(Verb.Type.ListIdentifiers).include(this.parameters).withResumptionToken(this.resumptionToken));
            XmlReader reader = new XmlReader(stream);
            ListIdentifiersParser parser = new ListIdentifiersParser(reader);
            while (parser.hasNext()) {
                headers.add(parser.next());
            }
            if (reader.current(this.resumptionToken())) {
                if (reader.next(new Matcher[]{XmlEventMatchers.text(), XmlEventMatchers.anEndElement()}).current(XmlEventMatchers.text())) {
                    String text = reader.getText();
                    if (text == null || "".equals(text.trim())) {
                        this.ended = true;
                    } else {
                        this.resumptionToken = text;
                    }
                } else {
                    this.ended = true;
                }
            } else {
                this.ended = true;
            }
            stream.close();
            return headers;
        }
        catch (XmlReaderException e) {
            throw new InvalidOAIResponse(e);
        }
        catch (OAIRequestException e) {
            throw new InvalidOAIResponse(e);
        }
        catch (IOException e) {
            throw new InvalidOAIResponse(e);
        }
    }

    private Matcher<XMLEvent> resumptionToken() {
        return AllOf.allOf((Matcher)XmlEventMatchers.aStartElement(), (Matcher)XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"resumptionToken"))));
    }

    @Override
    public boolean endReached() {
        return this.ended;
    }
}

