/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.serviceprovider.handler;

import com.lyncode.xml.XmlReader;
import com.lyncode.xml.exceptions.XmlReaderException;
import com.lyncode.xml.matchers.QNameMatchers;
import com.lyncode.xml.matchers.XmlEventMatchers;
import com.lyncode.xoai.model.oaipmh.Record;
import com.lyncode.xoai.model.oaipmh.Verb;
import com.lyncode.xoai.serviceprovider.client.OAIClient;
import com.lyncode.xoai.serviceprovider.exceptions.InvalidOAIResponse;
import com.lyncode.xoai.serviceprovider.exceptions.OAIRequestException;
import com.lyncode.xoai.serviceprovider.lazy.Source;
import com.lyncode.xoai.serviceprovider.model.Context;
import com.lyncode.xoai.serviceprovider.parameters.ListRecordsParameters;
import com.lyncode.xoai.serviceprovider.parameters.Parameters;
import com.lyncode.xoai.serviceprovider.parsers.ListRecordsParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.events.XMLEvent;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.AllOf;

public class ListRecordHandler
implements Source<Record> {
    private static final int DEFAULT_RETRIES = 5;
    private Context context;
    private ListRecordsParameters parameters;
    private OAIClient client;
    private String resumptionToken;
    private boolean ended = false;

    public ListRecordHandler(Context context, ListRecordsParameters parameters) {
        this.context = context;
        this.parameters = parameters;
        this.client = context.getClient();
    }

    @Override
    public List<Record> nextIteration() {
        int retries = 5;
        while (retries > 0) {
            try {
                return this.getNextIteration();
            }
            catch (XmlReaderException e) {
                if (retries > 0) {
                    --retries;
                    continue;
                }
                throw new InvalidOAIResponse(e);
            }
            catch (OAIRequestException e) {
                if (retries > 0) {
                    --retries;
                    continue;
                }
                throw new InvalidOAIResponse(e);
            }
            catch (IOException e) {
                throw new InvalidOAIResponse(e);
            }
        }
        throw new InvalidOAIResponse("Failed on reties in a way that should not happen");
    }

    private List<Record> getNextIteration() throws OAIRequestException, XmlReaderException, IOException {
        ArrayList<Record> records = new ArrayList<Record>();
        InputStream stream = null;
        stream = this.resumptionToken == null ? this.client.execute(Parameters.parameters().withVerb(Verb.Type.ListRecords).include(this.parameters)) : this.client.execute(Parameters.parameters().withVerb(Verb.Type.ListRecords).include(this.parameters).withResumptionToken(this.resumptionToken));
        XmlReader reader = new XmlReader(stream);
        ListRecordsParser parser = new ListRecordsParser(reader, this.context, this.parameters.getMetadataPrefix());
        while (parser.hasNext()) {
            records.add(parser.next());
        }
        if (reader.current(this.resumptionToken())) {
            if (reader.next(new Matcher[]{XmlEventMatchers.text(), XmlEventMatchers.anEndElement()}).current(XmlEventMatchers.text())) {
                String text = reader.getText();
                if (text == null || "".equals(text.trim()) || text.equals(this.resumptionToken)) {
                    this.ended = true;
                } else {
                    this.resumptionToken = text;
                }
            } else {
                this.ended = true;
            }
        } else {
            this.ended = true;
        }
        stream.close();
        return records;
    }

    private Matcher<XMLEvent> resumptionToken() {
        return AllOf.allOf((Matcher)XmlEventMatchers.aStartElement(), (Matcher)XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"resumptionToken"))));
    }

    @Override
    public boolean endReached() {
        return this.ended;
    }
}

