/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.serviceprovider.handler;

import com.lyncode.xml.XmlReader;
import com.lyncode.xml.exceptions.XmlReaderException;
import com.lyncode.xml.matchers.QNameMatchers;
import com.lyncode.xml.matchers.XmlEventMatchers;
import com.lyncode.xoai.model.oaipmh.Set;
import com.lyncode.xoai.model.oaipmh.Verb;
import com.lyncode.xoai.serviceprovider.client.OAIClient;
import com.lyncode.xoai.serviceprovider.exceptions.InvalidOAIResponse;
import com.lyncode.xoai.serviceprovider.exceptions.OAIRequestException;
import com.lyncode.xoai.serviceprovider.lazy.Source;
import com.lyncode.xoai.serviceprovider.model.Context;
import com.lyncode.xoai.serviceprovider.parameters.Parameters;
import com.lyncode.xoai.serviceprovider.parsers.ListSetsParser;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.events.XMLEvent;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.AllOf;

public class ListSetsHandler
implements Source<Set> {
    private Context context;
    private OAIClient client;
    private String resumptionToken;
    private boolean ended = false;

    public ListSetsHandler(Context context) {
        this.context = context;
        this.client = context.getClient();
    }

    @Override
    public List<Set> nextIteration() {
        ArrayList<Set> sets = new ArrayList();
        try {
            InputStream stream = null;
            stream = this.resumptionToken == null ? this.client.execute(Parameters.parameters().withVerb(Verb.Type.ListSets)) : this.client.execute(Parameters.parameters().withVerb(Verb.Type.ListSets).withResumptionToken(this.resumptionToken));
            XmlReader reader = new XmlReader(stream);
            ListSetsParser parser = new ListSetsParser(reader);
            sets = parser.parse();
            if (reader.current(this.resumptionToken())) {
                if (reader.next(new Matcher[]{XmlEventMatchers.text(), XmlEventMatchers.anEndElement()}).current(XmlEventMatchers.text())) {
                    String text = reader.getText();
                    if (text == null || "".equals(text.trim())) {
                        this.ended = true;
                    } else {
                        this.resumptionToken = text;
                    }
                } else {
                    this.ended = true;
                }
            } else {
                this.ended = true;
            }
            return sets;
        }
        catch (XmlReaderException e) {
            throw new InvalidOAIResponse(e);
        }
        catch (OAIRequestException e) {
            throw new InvalidOAIResponse(e);
        }
    }

    private Matcher<XMLEvent> resumptionToken() {
        return AllOf.allOf((Matcher)XmlEventMatchers.aStartElement(), (Matcher)XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"resumptionToken"))));
    }

    @Override
    public boolean endReached() {
        return this.ended;
    }
}

