/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.serviceprovider.parsers;

import com.lyncode.xml.XmlReader;
import com.lyncode.xml.exceptions.XmlReaderException;
import com.lyncode.xml.matchers.QNameMatchers;
import com.lyncode.xml.matchers.XmlEventMatchers;
import com.lyncode.xoai.model.oaipmh.Error;
import com.lyncode.xoai.model.oaipmh.Header;
import com.lyncode.xoai.serviceprovider.exceptions.InvalidOAIResponse;
import com.lyncode.xoai.serviceprovider.parsers.HeaderParser;
import javax.xml.stream.events.XMLEvent;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class ListIdentifiersParser {
    private final XmlReader reader;
    private boolean awaitingNextInvocation = false;

    public ListIdentifiersParser(XmlReader reader) {
        this.reader = reader;
    }

    public boolean hasNext() throws XmlReaderException {
        if (!this.awaitingNextInvocation) {
            this.reader.next(new Matcher[]{this.headerElement(), this.errorElement(), this.resumptionToken(), XmlEventMatchers.theEndOfDocument()});
        }
        this.awaitingNextInvocation = true;
        if (this.reader.current(this.errorElement())) {
            String code = this.reader.getAttributeValue(QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"code")));
            if (CoreMatchers.equalTo((Object)Error.Code.NO_RECORDS_MATCH.code()).matches((Object)code)) {
                return false;
            }
            throw new InvalidOAIResponse("OAI responded with code: " + code);
        }
        return this.reader.current(this.headerElement());
    }

    private Matcher<XMLEvent> resumptionToken() {
        return CoreMatchers.allOf((Matcher)XmlEventMatchers.aStartElement(), (Matcher)XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"resumptionToken"))));
    }

    public Header next() throws XmlReaderException {
        if (!this.hasNext()) {
            throw new XmlReaderException("No more identifiers available");
        }
        this.awaitingNextInvocation = false;
        return new HeaderParser().parse(this.reader);
    }

    private Matcher<XMLEvent> errorElement() {
        return XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"error")));
    }

    private Matcher<XMLEvent> headerElement() {
        return CoreMatchers.allOf((Matcher)XmlEventMatchers.aStartElement(), (Matcher)XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"header"))));
    }
}

