/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.serviceprovider.parsers;

import com.lyncode.xml.XmlReader;
import com.lyncode.xml.exceptions.XmlReaderException;
import com.lyncode.xml.matchers.QNameMatchers;
import com.lyncode.xml.matchers.XmlEventMatchers;
import com.lyncode.xoai.model.oaipmh.Error;
import com.lyncode.xoai.model.oaipmh.Record;
import com.lyncode.xoai.serviceprovider.exceptions.InvalidOAIResponse;
import com.lyncode.xoai.serviceprovider.model.Context;
import com.lyncode.xoai.serviceprovider.parsers.RecordParser;
import javax.xml.stream.events.XMLEvent;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class ListRecordsParser {
    private final XmlReader reader;
    private final Context context;
    private final String metadataPrefix;
    private boolean awaitingNextInvocation = false;

    public ListRecordsParser(XmlReader reader, Context context, String metadataPrefix) {
        this.reader = reader;
        this.context = context;
        this.metadataPrefix = metadataPrefix;
    }

    public boolean hasNext() throws XmlReaderException {
        if (!this.awaitingNextInvocation) {
            this.reader.next(new Matcher[]{this.recordElement(), this.errorElement(), this.resumptionToken(), XmlEventMatchers.theEndOfDocument()});
        }
        this.awaitingNextInvocation = true;
        if (this.reader.current(this.errorElement())) {
            String code = this.reader.getAttributeValue(QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"code")));
            if (CoreMatchers.equalTo((Object)Error.Code.NO_RECORDS_MATCH.code()).matches((Object)code)) {
                return false;
            }
            throw new InvalidOAIResponse("OAI responded with code: " + code);
        }
        return this.reader.current(this.recordElement());
    }

    private Matcher<XMLEvent> resumptionToken() {
        return CoreMatchers.allOf((Matcher)XmlEventMatchers.aStartElement(), (Matcher)XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"resumptionToken"))));
    }

    public Record next() throws XmlReaderException {
        if (!this.hasNext()) {
            throw new XmlReaderException("No more records available");
        }
        this.awaitingNextInvocation = false;
        return new RecordParser(this.context, this.metadataPrefix).parse(this.reader);
    }

    private Matcher<XMLEvent> errorElement() {
        return XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"error")));
    }

    private Matcher<XMLEvent> recordElement() {
        return CoreMatchers.allOf((Matcher)XmlEventMatchers.aStartElement(), (Matcher)XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"record"))));
    }
}

