/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.serviceprovider.parsers;

import com.lyncode.xml.XmlReader;
import com.lyncode.xml.exceptions.XmlReaderException;
import com.lyncode.xml.matchers.QNameMatchers;
import com.lyncode.xml.matchers.XmlEventMatchers;
import com.lyncode.xoai.model.oaipmh.Error;
import com.lyncode.xoai.model.oaipmh.Set;
import com.lyncode.xoai.serviceprovider.exceptions.EncapsulatedKnownException;
import com.lyncode.xoai.serviceprovider.exceptions.InvalidOAIResponse;
import com.lyncode.xoai.serviceprovider.exceptions.NoSetHierarchyException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.events.XMLEvent;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class ListSetsParser {
    private final XmlReader reader;
    private boolean awaitingNextInvocation = false;

    public ListSetsParser(XmlReader reader) {
        this.reader = reader;
    }

    public boolean hasNext() throws XmlReaderException {
        if (!this.awaitingNextInvocation) {
            this.reader.next(new Matcher[]{this.setElement(), this.errorElement(), this.resumptionToken(), XmlEventMatchers.theEndOfDocument()});
        }
        this.awaitingNextInvocation = true;
        if (this.reader.current(this.errorElement())) {
            String code = this.reader.getAttributeValue(QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"code")));
            if (CoreMatchers.equalTo((Object)Error.Code.NO_RECORDS_MATCH.code()).matches((Object)code)) {
                return false;
            }
            if (CoreMatchers.equalTo((Object)Error.Code.NO_SET_HIERARCHY.code()).matches((Object)code)) {
                throw new EncapsulatedKnownException(new NoSetHierarchyException());
            }
            throw new InvalidOAIResponse("OAI responded with code: " + code);
        }
        return this.reader.current(this.setElement());
    }

    private Matcher<XMLEvent> resumptionToken() {
        return CoreMatchers.allOf((Matcher)XmlEventMatchers.aStartElement(), (Matcher)XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"resumptionToken"))));
    }

    public Set next() throws XmlReaderException {
        if (!this.hasNext()) {
            throw new XmlReaderException("No more identifiers available");
        }
        this.awaitingNextInvocation = false;
        return this.parseSet();
    }

    private Set parseSet() throws XmlReaderException {
        Set set = new Set();
        String setName = null;
        String setSpec = null;
        while (setName == null || setSpec == null) {
            this.reader.next(new Matcher[]{XmlEventMatchers.aStartElement()});
            QName elementName = this.reader.getName();
            this.reader.next(new Matcher[]{XmlEventMatchers.text()});
            String extractedText = this.reader.getText();
            while (this.reader.next(new Matcher[]{XmlEventMatchers.anEndElement(), XmlEventMatchers.text()}).current(XmlEventMatchers.text())) {
                extractedText = extractedText + this.reader.getText();
            }
            if (elementName.getLocalPart().equals("setName")) {
                setName = extractedText;
                continue;
            }
            if (!elementName.getLocalPart().equals("setSpec")) continue;
            setSpec = extractedText;
        }
        set.withName(setName);
        set.withSpec(setSpec);
        return set;
    }

    private Matcher<XMLEvent> errorElement() {
        return XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"error")));
    }

    private Matcher<XMLEvent> setElement() {
        return CoreMatchers.allOf((Matcher)XmlEventMatchers.aStartElement(), (Matcher)XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"set"))));
    }

    private Matcher<XMLEvent> endSetElement() {
        return CoreMatchers.allOf((Matcher)XmlEventMatchers.anEndElement(), (Matcher)XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"set"))));
    }

    public List<Set> parse() throws XmlReaderException {
        ArrayList<Set> sets = new ArrayList<Set>();
        while (this.hasNext()) {
            sets.add(this.next());
        }
        return sets;
    }
}

