/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.serviceprovider.parsers;

import com.lyncode.xml.XmlReader;
import com.lyncode.xml.exceptions.XmlReaderException;
import com.lyncode.xml.matchers.QNameMatchers;
import com.lyncode.xml.matchers.XmlEventMatchers;
import com.lyncode.xoai.model.oaipmh.About;
import com.lyncode.xoai.model.oaipmh.Metadata;
import com.lyncode.xoai.model.oaipmh.Record;
import com.lyncode.xoai.serviceprovider.exceptions.InternalHarvestException;
import com.lyncode.xoai.serviceprovider.model.Context;
import com.lyncode.xoai.serviceprovider.parsers.HeaderParser;
import com.lyncode.xoai.serviceprovider.parsers.MetadataParser;
import com.lyncode.xoai.xml.XSLPipeline;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.TransformerException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class RecordParser {
    private final Context context;
    private String metadataPrefix;

    public RecordParser(Context context, String metadataPrefix) {
        this.context = context;
        this.metadataPrefix = metadataPrefix;
    }

    public Record parse(XmlReader reader) throws XmlReaderException {
        HeaderParser headerParser = new HeaderParser();
        reader.next(new Matcher[]{XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"header")))});
        Record record = new Record().withHeader(headerParser.parse(reader));
        if (!record.getHeader().isDeleted()) {
            reader.next(new Matcher[]{XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"metadata")))}).next(new Matcher[]{XmlEventMatchers.aStartElement()});
            String content = reader.retrieveCurrentAsString();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes());
            XSLPipeline pipeline = new XSLPipeline((InputStream)inputStream, true).apply(this.context.getMetadataTransformer(this.metadataPrefix));
            if (this.context.hasTransformer()) {
                pipeline.apply(this.context.getTransformer());
            }
            try {
                record.withMetadata(new Metadata(new MetadataParser().parse(pipeline.process())));
            }
            catch (TransformerException e) {
                throw new InternalHarvestException("Unable to process transformer");
            }
        }
        if (reader.next(new Matcher[]{this.aboutElement(), this.endOfRecord()}).current(this.aboutElement())) {
            reader.next(new Matcher[]{XmlEventMatchers.aStartElement()});
            record.withAbout(new About(reader.retrieveCurrentAsString()));
        }
        return record;
    }

    private Matcher<XMLEvent> endOfRecord() {
        return CoreMatchers.allOf((Matcher)XmlEventMatchers.anEndElement(), (Matcher)XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"record"))));
    }

    private Matcher<XMLEvent> aboutElement() {
        return XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"about")));
    }
}

