/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.serviceprovider;

import java.util.Iterator;
import org.dspace.xoai.model.oaipmh.Header;
import org.dspace.xoai.model.oaipmh.Identify;
import org.dspace.xoai.model.oaipmh.MetadataFormat;
import org.dspace.xoai.model.oaipmh.Record;
import org.dspace.xoai.model.oaipmh.Set;
import org.dspace.xoai.serviceprovider.exceptions.BadArgumentException;
import org.dspace.xoai.serviceprovider.exceptions.CannotDisseminateFormatException;
import org.dspace.xoai.serviceprovider.exceptions.EncapsulatedKnownException;
import org.dspace.xoai.serviceprovider.exceptions.HarvestException;
import org.dspace.xoai.serviceprovider.exceptions.IdDoesNotExistException;
import org.dspace.xoai.serviceprovider.exceptions.NoSetHierarchyException;
import org.dspace.xoai.serviceprovider.handler.GetRecordHandler;
import org.dspace.xoai.serviceprovider.handler.IdentifyHandler;
import org.dspace.xoai.serviceprovider.handler.ListIdentifierHandler;
import org.dspace.xoai.serviceprovider.handler.ListMetadataFormatsHandler;
import org.dspace.xoai.serviceprovider.handler.ListRecordHandler;
import org.dspace.xoai.serviceprovider.handler.ListSetsHandler;
import org.dspace.xoai.serviceprovider.lazy.ItemIterator;
import org.dspace.xoai.serviceprovider.model.Context;
import org.dspace.xoai.serviceprovider.parameters.GetRecordParameters;
import org.dspace.xoai.serviceprovider.parameters.ListIdentifiersParameters;
import org.dspace.xoai.serviceprovider.parameters.ListMetadataParameters;
import org.dspace.xoai.serviceprovider.parameters.ListRecordsParameters;

public class ServiceProvider {
    private Context context;
    private ListMetadataFormatsHandler listMetadataFormatsHandler;
    private IdentifyHandler identifyHandler;
    private GetRecordHandler getRecordHandler;

    public ServiceProvider(Context context) {
        this.context = context;
        this.identifyHandler = new IdentifyHandler(context);
        this.listMetadataFormatsHandler = new ListMetadataFormatsHandler(context);
        this.getRecordHandler = new GetRecordHandler(context);
    }

    public Identify identify() {
        return this.identifyHandler.handle();
    }

    public Iterator<MetadataFormat> listMetadataFormats() throws IdDoesNotExistException {
        return this.listMetadataFormatsHandler.handle(ListMetadataParameters.request()).iterator();
    }

    public Iterator<MetadataFormat> listMetadataFormats(ListMetadataParameters parameters) throws IdDoesNotExistException {
        return this.listMetadataFormatsHandler.handle(parameters).iterator();
    }

    public Record getRecord(GetRecordParameters parameters) throws BadArgumentException, IdDoesNotExistException, CannotDisseminateFormatException {
        if (!parameters.areValid()) {
            throw new BadArgumentException("GetRecord verb requires identifier and metadataPrefix parameters");
        }
        return this.getRecordHandler.handle(parameters);
    }

    public Iterator<Record> listRecords(ListRecordsParameters parameters) throws BadArgumentException {
        if (!parameters.areValid()) {
            throw new BadArgumentException("ListRecords verb requires the metadataPrefix");
        }
        return new ItemIterator<Record>(new ListRecordHandler(this.context, parameters));
    }

    public Iterator<Header> listIdentifiers(ListIdentifiersParameters parameters) throws BadArgumentException {
        if (!parameters.areValid()) {
            throw new BadArgumentException("ListIdentifiers verb requires the metadataPrefix");
        }
        return new ItemIterator<Header>(new ListIdentifierHandler(this.context, parameters));
    }

    public Iterator<Set> listSets() throws NoSetHierarchyException {
        try {
            return new ItemIterator<Set>(new ListSetsHandler(this.context));
        }
        catch (EncapsulatedKnownException ex) {
            throw this.get(ex, NoSetHierarchyException.class);
        }
    }

    private <T extends HarvestException> boolean instanceOf(EncapsulatedKnownException exception, Class<T> exceptionClass) {
        return exceptionClass.isInstance(exception.getCause());
    }

    private <T extends HarvestException> T get(EncapsulatedKnownException ex, Class<T> exceptionClass) {
        if (this.instanceOf(ex, exceptionClass)) {
            return (T)((HarvestException)ex.getCause());
        }
        return null;
    }
}

