/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.serviceprovider.client;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.BasicClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.dspace.xoai.serviceprovider.client.OAIClient;
import org.dspace.xoai.serviceprovider.exceptions.HttpException;
import org.dspace.xoai.serviceprovider.parameters.Parameters;

public class HttpOAIClient
implements OAIClient {
    private String baseUrl;
    private HttpClient httpclient;
    private int timeout = 60000;
    private String userAgent;
    private List<String> baseUrlsHttpsExclusion;

    public HttpOAIClient(String baseUrl) {
        this.baseUrl = baseUrl;
        this.httpclient = new DefaultHttpClient(this.createHttpParams());
    }

    public HttpOAIClient(String baseUrl, List<String> baseUrlsHttpsExclusion) throws HttpException {
        this.baseUrl = baseUrl;
        this.baseUrlsHttpsExclusion = baseUrlsHttpsExclusion;
        this.initHttpClient();
    }

    public HttpOAIClient(String baseUrl, List<String> baseUrlsHttpsExclusion, int timeout) throws HttpException {
        this.timeout = timeout;
        this.baseUrl = baseUrl;
        this.baseUrlsHttpsExclusion = baseUrlsHttpsExclusion;
        this.initHttpClient();
    }

    public HttpOAIClient(String baseUrl, List<String> baseUrlsHttpsExclusion, int timeout, String userAgent) throws HttpException {
        this.timeout = timeout;
        this.baseUrl = baseUrl;
        this.baseUrlsHttpsExclusion = baseUrlsHttpsExclusion;
        this.userAgent = userAgent;
        this.initHttpClient();
    }

    @Override
    public InputStream execute(Parameters parameters) throws HttpException {
        try {
            HttpResponse response = this.httpclient.execute(this.createGetRequest(parameters));
            if (response.getStatusLine().getStatusCode() == 200) {
                return response.getEntity().getContent();
            }
            throw new HttpException("Error querying service. Returned HTTP Status Code: " + response.getStatusLine().getStatusCode());
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
    }

    private HttpUriRequest createGetRequest(Parameters parameters) {
        return new HttpGet(parameters.toUrl(this.baseUrl));
    }

    private void initHttpClient() throws HttpException {
        try {
            if (this.baseUrlsHttpsExclusion != null && this.baseUrlsHttpsExclusion.contains(this.baseUrl)) {
                SSLSocketFactory sslsf = new SSLSocketFactory(new TrustStrategy(){

                    public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        return true;
                    }
                }, (X509HostnameVerifier)new AllowAllHostnameVerifier());
                Scheme httpsScheme = new Scheme("https", 443, (SchemeSocketFactory)sslsf);
                SchemeRegistry schemeRegistry = new SchemeRegistry();
                schemeRegistry.register(httpsScheme);
                BasicClientConnectionManager cm = new BasicClientConnectionManager(schemeRegistry);
                this.httpclient = new DefaultHttpClient((ClientConnectionManager)cm, this.createHttpParams());
            } else {
                this.httpclient = new DefaultHttpClient(this.createHttpParams());
            }
        }
        catch (KeyManagementException e) {
            throw new HttpException(e);
        }
        catch (UnrecoverableKeyException e) {
            throw new HttpException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new HttpException(e);
        }
        catch (KeyStoreException e) {
            throw new HttpException(e);
        }
    }

    private HttpParams createHttpParams() {
        BasicHttpParams httpParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)this.timeout);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)this.timeout);
        if (this.userAgent != null) {
            httpParams.setParameter("http.useragent", (Object)this.userAgent);
        }
        return httpParams;
    }
}

