/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.serviceprovider.handler;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.dspace.xoai.model.oaipmh.Identify;
import org.dspace.xoai.model.oaipmh.Verb;
import org.dspace.xoai.serviceprovider.client.OAIClient;
import org.dspace.xoai.serviceprovider.exceptions.InvalidOAIResponse;
import org.dspace.xoai.serviceprovider.exceptions.OAIRequestException;
import org.dspace.xoai.serviceprovider.model.Context;
import org.dspace.xoai.serviceprovider.parameters.Parameters;
import org.dspace.xoai.serviceprovider.parsers.IdentifyParser;

public class IdentifyHandler {
    private final OAIClient client;

    public IdentifyHandler(Context context) {
        this.client = context.getClient();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Identify handle() {
        Identify identify;
        InputStream stream = null;
        try {
            stream = this.client.execute(Parameters.parameters().withVerb(Verb.Type.Identify));
            Identify identify2 = new IdentifyParser(stream).parse();
            stream.close();
            identify = identify2;
        }
        catch (OAIRequestException e) {
            try {
                throw new InvalidOAIResponse(e);
                catch (IOException e2) {
                    throw new InvalidOAIResponse(e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)stream);
        return identify;
    }
}

