/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.serviceprovider.handler;

import com.lyncode.xml.XmlReader;
import com.lyncode.xml.exceptions.XmlReaderException;
import com.lyncode.xml.matchers.QNameMatchers;
import com.lyncode.xml.matchers.XmlEventMatchers;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.io.IOUtils;
import org.dspace.xoai.model.oaipmh.Header;
import org.dspace.xoai.model.oaipmh.Verb;
import org.dspace.xoai.serviceprovider.client.OAIClient;
import org.dspace.xoai.serviceprovider.exceptions.InvalidOAIResponse;
import org.dspace.xoai.serviceprovider.exceptions.OAIRequestException;
import org.dspace.xoai.serviceprovider.lazy.Source;
import org.dspace.xoai.serviceprovider.model.Context;
import org.dspace.xoai.serviceprovider.parameters.ListIdentifiersParameters;
import org.dspace.xoai.serviceprovider.parameters.Parameters;
import org.dspace.xoai.serviceprovider.parsers.ListIdentifiersParser;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.AllOf;

public class ListIdentifierHandler
implements Source<Header> {
    private Context context;
    private ListIdentifiersParameters parameters;
    private OAIClient client;
    private String resumptionToken;
    private boolean ended = false;

    public ListIdentifierHandler(Context context, ListIdentifiersParameters parameters) {
        this.context = context;
        this.parameters = parameters;
        this.client = context.getClient();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Header> nextIteration() {
        ArrayList<Header> arrayList;
        ArrayList<Header> headers = new ArrayList<Header>();
        InputStream stream = null;
        try {
            block11: {
                block12: {
                    stream = this.resumptionToken == null ? this.client.execute(Parameters.parameters().withVerb(Verb.Type.ListIdentifiers).include(this.parameters)) : this.client.execute(Parameters.parameters().withVerb(Verb.Type.ListIdentifiers).include(this.parameters).withResumptionToken(this.resumptionToken));
                    XmlReader reader = new XmlReader(stream);
                    ListIdentifiersParser parser = new ListIdentifiersParser(reader);
                    while (parser.hasNext()) {
                        headers.add(parser.next());
                    }
                    if (!reader.current(this.resumptionToken())) break block12;
                    if (reader.next(new Matcher[]{XmlEventMatchers.text(), XmlEventMatchers.anEndElement()}).current(XmlEventMatchers.text())) {
                        String text = reader.getText();
                        if (text == null || "".equals(text.trim())) {
                            this.ended = true;
                            break block11;
                        } else {
                            this.resumptionToken = text;
                        }
                        break block11;
                    } else {
                        this.ended = true;
                    }
                    break block11;
                }
                this.ended = true;
            }
            stream.close();
            arrayList = headers;
        }
        catch (XmlReaderException e) {
            try {
                throw new InvalidOAIResponse(e);
                catch (OAIRequestException e2) {
                    throw new InvalidOAIResponse(e2);
                }
                catch (IOException e3) {
                    throw new InvalidOAIResponse(e3);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)stream);
        return arrayList;
    }

    private Matcher<XMLEvent> resumptionToken() {
        return AllOf.allOf((Matcher)XmlEventMatchers.aStartElement(), (Matcher)XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"resumptionToken"))));
    }

    @Override
    public boolean endReached() {
        return this.ended;
    }
}

