/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.serviceprovider.handler;

import com.lyncode.xml.exceptions.XmlReaderException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.dspace.xoai.model.oaipmh.MetadataFormat;
import org.dspace.xoai.model.oaipmh.Verb;
import org.dspace.xoai.serviceprovider.client.OAIClient;
import org.dspace.xoai.serviceprovider.exceptions.IdDoesNotExistException;
import org.dspace.xoai.serviceprovider.exceptions.InvalidOAIResponse;
import org.dspace.xoai.serviceprovider.exceptions.OAIRequestException;
import org.dspace.xoai.serviceprovider.model.Context;
import org.dspace.xoai.serviceprovider.parameters.ListMetadataParameters;
import org.dspace.xoai.serviceprovider.parameters.Parameters;
import org.dspace.xoai.serviceprovider.parsers.MetadataFormatParser;

public class ListMetadataFormatsHandler {
    private OAIClient client;

    public ListMetadataFormatsHandler(Context context) {
        this.client = context.getClient();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<MetadataFormat> handle(ListMetadataParameters parameters) throws IdDoesNotExistException {
        ArrayList<MetadataFormat> arrayList;
        ArrayList<MetadataFormat> result = new ArrayList<MetadataFormat>();
        InputStream stream = null;
        try {
            stream = this.client.execute(Parameters.parameters().withVerb(Verb.Type.ListMetadataFormats).include(parameters));
            MetadataFormatParser parser = new MetadataFormatParser(stream);
            while (parser.hasNext()) {
                result.add(parser.next());
            }
            stream.close();
            arrayList = result;
        }
        catch (XmlReaderException e) {
            try {
                throw new InvalidOAIResponse(e);
                catch (OAIRequestException e2) {
                    throw new InvalidOAIResponse(e2);
                }
                catch (IOException e3) {
                    throw new InvalidOAIResponse(e3);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)stream);
        return arrayList;
    }
}

