/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.serviceprovider.handler;

import com.lyncode.xml.XmlReader;
import com.lyncode.xml.exceptions.XmlReaderException;
import com.lyncode.xml.matchers.QNameMatchers;
import com.lyncode.xml.matchers.XmlEventMatchers;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.io.IOUtils;
import org.dspace.xoai.model.oaipmh.Set;
import org.dspace.xoai.model.oaipmh.Verb;
import org.dspace.xoai.serviceprovider.client.OAIClient;
import org.dspace.xoai.serviceprovider.exceptions.InvalidOAIResponse;
import org.dspace.xoai.serviceprovider.exceptions.OAIRequestException;
import org.dspace.xoai.serviceprovider.lazy.Source;
import org.dspace.xoai.serviceprovider.model.Context;
import org.dspace.xoai.serviceprovider.parameters.Parameters;
import org.dspace.xoai.serviceprovider.parsers.ListSetsParser;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.AllOf;

public class ListSetsHandler
implements Source<Set> {
    private Context context;
    private OAIClient client;
    private String resumptionToken;
    private boolean ended = false;

    public ListSetsHandler(Context context) {
        this.context = context;
        this.client = context.getClient();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Set> nextIteration() {
        ArrayList<Set> arrayList;
        ArrayList<Set> sets = new ArrayList();
        InputStream stream = null;
        try {
            block10: {
                block11: {
                    stream = this.resumptionToken == null ? this.client.execute(Parameters.parameters().withVerb(Verb.Type.ListSets)) : this.client.execute(Parameters.parameters().withVerb(Verb.Type.ListSets).withResumptionToken(this.resumptionToken));
                    XmlReader reader = new XmlReader(stream);
                    ListSetsParser parser = new ListSetsParser(reader);
                    sets = parser.parse();
                    if (!reader.current(this.resumptionToken())) break block11;
                    if (reader.next(new Matcher[]{XmlEventMatchers.text(), XmlEventMatchers.anEndElement()}).current(XmlEventMatchers.text())) {
                        String text = reader.getText();
                        if (text == null || "".equals(text.trim())) {
                            this.ended = true;
                            break block10;
                        } else {
                            this.resumptionToken = text;
                        }
                        break block10;
                    } else {
                        this.ended = true;
                    }
                    break block10;
                }
                this.ended = true;
            }
            stream.close();
            arrayList = sets;
        }
        catch (XmlReaderException e) {
            try {
                throw new InvalidOAIResponse(e);
                catch (OAIRequestException e2) {
                    throw new InvalidOAIResponse(e2);
                }
                catch (IOException e3) {
                    throw new InvalidOAIResponse(e3);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)stream);
        return arrayList;
    }

    private Matcher<XMLEvent> resumptionToken() {
        return AllOf.allOf((Matcher)XmlEventMatchers.aStartElement(), (Matcher)XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"resumptionToken"))));
    }

    @Override
    public boolean endReached() {
        return this.ended;
    }
}

