/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.serviceprovider.parameters;

import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.dspace.xoai.model.oaipmh.Granularity;
import org.dspace.xoai.model.oaipmh.Verb;
import org.dspace.xoai.serviceprovider.parameters.GetRecordParameters;
import org.dspace.xoai.serviceprovider.parameters.ListIdentifiersParameters;
import org.dspace.xoai.serviceprovider.parameters.ListMetadataParameters;
import org.dspace.xoai.serviceprovider.parameters.ListRecordsParameters;
import org.dspace.xoai.services.api.DateProvider;
import org.dspace.xoai.services.impl.UTCDateProvider;
import org.dspace.xoai.util.URLEncoder;

public class Parameters {
    private static DateProvider formatter = new UTCDateProvider();
    private Verb.Type verb;
    private String metadataPrefix;
    private String set;
    private Date from;
    private Date until;
    private String identifier;
    private String resumptionToken;
    private String granularity;

    public static Parameters parameters() {
        return new Parameters();
    }

    public Parameters withVerb(Verb.Type verb) {
        this.verb = verb;
        return this;
    }

    public Parameters withUntil(Date until) {
        this.until = until;
        return this;
    }

    public Parameters withFrom(Date from) {
        this.from = from;
        return this;
    }

    public Parameters withSet(String value) {
        this.set = value;
        return this;
    }

    public Parameters identifier(String value) {
        this.identifier = value;
        return this;
    }

    public Parameters withResumptionToken(String value) {
        this.resumptionToken = value;
        this.metadataPrefix = null;
        this.until = null;
        this.set = null;
        this.from = null;
        return this;
    }

    public Parameters withoutResumptionToken() {
        this.resumptionToken = null;
        return this;
    }

    public Parameters withMetadataPrefix(String value) {
        this.metadataPrefix = value;
        return this;
    }

    public String toUrl(String baseUrl) {
        ArrayList<String> string = new ArrayList<String>();
        string.add("verb=" + this.verb.name());
        Granularity granularity = this.granularity();
        if (this.set != null) {
            string.add("set=" + URLEncoder.encode((String)this.set));
        }
        if (this.from != null) {
            string.add("from=" + URLEncoder.encode((String)formatter.format(this.from, granularity)));
        }
        if (this.until != null) {
            string.add("until=" + URLEncoder.encode((String)formatter.format(this.until, granularity)));
        }
        if (this.identifier != null) {
            string.add("identifier=" + URLEncoder.encode((String)this.identifier));
        }
        if (this.metadataPrefix != null) {
            string.add("metadataPrefix=" + URLEncoder.encode((String)this.metadataPrefix));
        }
        if (this.resumptionToken != null) {
            string.add("resumptionToken=" + URLEncoder.encode((String)this.resumptionToken));
        }
        return baseUrl + "?" + StringUtils.join(string, (String)"&");
    }

    private Granularity granularity() {
        if (this.granularity != null) {
            for (int i = 0; i < Granularity.values().length; ++i) {
                Granularity possibleGranularity = Granularity.values()[i];
                if (!this.granularity.equals(possibleGranularity.toString())) continue;
                return possibleGranularity;
            }
        }
        return Granularity.Second;
    }

    public Parameters include(ListMetadataParameters parameters) {
        this.identifier = parameters.getIdentifier();
        return this;
    }

    public Parameters include(GetRecordParameters parameters) {
        this.identifier = parameters.getIdentifier();
        this.metadataPrefix = parameters.getMetadataPrefix();
        return this;
    }

    public Parameters include(ListRecordsParameters parameters) {
        this.metadataPrefix = parameters.getMetadataPrefix();
        this.set = parameters.getSetSpec();
        this.until = parameters.getUntil();
        this.from = parameters.getFrom();
        this.granularity = parameters.getGranularity();
        return this;
    }

    public Parameters include(ListIdentifiersParameters parameters) {
        this.metadataPrefix = parameters.getMetadataPrefix();
        this.set = parameters.getSetSpec();
        this.until = parameters.getUntil();
        this.from = parameters.getFrom();
        this.granularity = parameters.getGranularity();
        return this;
    }

    public Verb.Type getVerb() {
        return this.verb;
    }

    public String getMetadataPrefix() {
        return this.metadataPrefix;
    }

    public String getSet() {
        return this.set;
    }

    public Date getFrom() {
        return this.from;
    }

    public Date getUntil() {
        return this.until;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getResumptionToken() {
        return this.resumptionToken;
    }

    public void withGranularity(String granularity) {
        this.granularity = granularity;
    }

    public Object getGranularity() {
        return this.granularity;
    }
}

