/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.serviceprovider.parsers;

import com.lyncode.xml.XmlReader;
import com.lyncode.xml.exceptions.XmlReaderException;
import com.lyncode.xml.matchers.QNameMatchers;
import com.lyncode.xml.matchers.XmlEventMatchers;
import java.io.InputStream;
import javax.xml.stream.events.XMLEvent;
import org.dspace.xoai.model.oaipmh.Error;
import org.dspace.xoai.model.oaipmh.Record;
import org.dspace.xoai.serviceprovider.exceptions.CannotDisseminateFormatException;
import org.dspace.xoai.serviceprovider.exceptions.IdDoesNotExistException;
import org.dspace.xoai.serviceprovider.exceptions.InvalidOAIResponse;
import org.dspace.xoai.serviceprovider.model.Context;
import org.dspace.xoai.serviceprovider.parsers.RecordParser;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class GetRecordParser {
    private final XmlReader reader;
    private Context context;
    private String metadataPrefix;

    public GetRecordParser(InputStream stream, Context context, String metadataPrefix) {
        this.context = context;
        this.metadataPrefix = metadataPrefix;
        try {
            this.reader = new XmlReader(stream);
        }
        catch (XmlReaderException e) {
            throw new InvalidOAIResponse(e);
        }
    }

    public Record parse() throws IdDoesNotExistException, CannotDisseminateFormatException {
        try {
            this.reader.next(new Matcher[]{this.errorElement(), this.recordElement()});
            if (this.reader.current(this.errorElement())) {
                String code = this.reader.getAttributeValue(QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"code")));
                if (Error.Code.ID_DOES_NOT_EXIST.code().equals(code)) {
                    throw new IdDoesNotExistException();
                }
                if (Error.Code.CANNOT_DISSEMINATE_FORMAT.code().equals(code)) {
                    throw new CannotDisseminateFormatException();
                }
                throw new InvalidOAIResponse("OAI responded with error code: " + code);
            }
            return new RecordParser(this.context, this.metadataPrefix).parse(this.reader);
        }
        catch (XmlReaderException e) {
            throw new InvalidOAIResponse(e);
        }
    }

    private Matcher<XMLEvent> errorElement() {
        return XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"error")));
    }

    private Matcher<XMLEvent> recordElement() {
        return XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"record")));
    }
}

