/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.serviceprovider.parsers;

import com.lyncode.xml.XmlReader;
import com.lyncode.xml.exceptions.XmlReaderException;
import com.lyncode.xml.matchers.QNameMatchers;
import com.lyncode.xml.matchers.XmlEventMatchers;
import java.io.InputStream;
import java.util.Date;
import org.dspace.xoai.model.oaipmh.DeletedRecord;
import org.dspace.xoai.model.oaipmh.Description;
import org.dspace.xoai.model.oaipmh.Granularity;
import org.dspace.xoai.model.oaipmh.Identify;
import org.dspace.xoai.serviceprovider.exceptions.InvalidOAIResponse;
import org.dspace.xoai.serviceprovider.xml.IslandParsers;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class IdentifyParser {
    private final XmlReader reader;

    public IdentifyParser(InputStream stream) {
        try {
            this.reader = new XmlReader(stream);
        }
        catch (XmlReaderException e) {
            throw new InvalidOAIResponse(e);
        }
    }

    public Identify parse() {
        try {
            Identify identify = new Identify();
            this.reader.next(new Matcher[]{CoreMatchers.allOf((Matcher)XmlEventMatchers.aStartElement(), (Matcher)XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"Identify"))))});
            this.reader.next(new Matcher[]{XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"repositoryName")))});
            identify.withRepositoryName(this.reader.next(new Matcher[]{XmlEventMatchers.text()}).getText());
            this.reader.next(new Matcher[]{XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"baseURL")))});
            identify.withBaseURL(this.reader.next(new Matcher[]{XmlEventMatchers.text()}).getText());
            this.reader.next(new Matcher[]{XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"protocolVersion")))});
            identify.withProtocolVersion(this.reader.next(new Matcher[]{XmlEventMatchers.text()}).getText());
            this.reader.next(new Matcher[]{XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"adminEmail")))}).next(new Matcher[]{XmlEventMatchers.text()});
            identify.withAdminEmail(this.reader.getText());
            while (this.reader.next(new Matcher[]{XmlEventMatchers.aStartElement()}).current(XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"adminEmail"))))) {
                identify.withAdminEmail(this.reader.next(new Matcher[]{XmlEventMatchers.text()}).getText());
            }
            identify.withEarliestDatestamp((Date)this.reader.next(new Matcher[]{XmlEventMatchers.text()}).get(IslandParsers.dateParser()));
            this.reader.next(new Matcher[]{XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"deletedRecord")))}).next(new Matcher[]{XmlEventMatchers.text()});
            identify.withDeletedRecord(DeletedRecord.fromValue((String)this.reader.getText()));
            this.reader.next(new Matcher[]{XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"granularity")))}).next(new Matcher[]{XmlEventMatchers.text()});
            identify.withGranularity(Granularity.fromRepresentation((String)this.reader.getText()));
            while (this.reader.next(new Matcher[]{XmlEventMatchers.aStartElement(), XmlEventMatchers.theEndOfDocument()}).current(XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"compression"))))) {
                identify.withCompression(this.reader.next(new Matcher[]{XmlEventMatchers.text()}).getText());
            }
            if (this.reader.current(XmlEventMatchers.theEndOfDocument())) {
                return identify;
            }
            if (this.reader.current(XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"description"))))) {
                identify.withDescription((Description)this.reader.get(this.descriptionParser()));
            }
            while (this.reader.next(new Matcher[]{XmlEventMatchers.aStartElement(), XmlEventMatchers.theEndOfDocument()}).current(XmlEventMatchers.elementName((Matcher)QNameMatchers.localPart((Matcher)CoreMatchers.equalTo((Object)"description"))))) {
                identify.withDescription((Description)this.reader.get(this.descriptionParser()));
            }
            return identify;
        }
        catch (XmlReaderException e) {
            throw new InvalidOAIResponse(e);
        }
    }

    private XmlReader.IslandParser<Description> descriptionParser() {
        return new XmlReader.IslandParser<Description>(){

            public Description parse(XmlReader reader) throws XmlReaderException {
                return new Description(reader.retrieveCurrentAsString());
            }
        };
    }
}

