/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.PDResources;
import org.pdfbox.pdmodel.encryption.AccessPermission;
import org.pdfbox.pdmodel.encryption.StandardDecryptionMaterial;
import org.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;

public class ExtractImages {
    private int imageCounter = 1;
    private static final String PASSWORD = "-password";
    private static final String PREFIX = "-prefix";

    public static void main(String[] args) throws Exception {
        ExtractImages extractor = new ExtractImages();
        extractor.extractImages(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractImages(String[] args) throws Exception {
        if (args.length < 1 || args.length > 3) {
            ExtractImages.usage();
        } else {
            String pdfFile = null;
            String password = "";
            String prefix = null;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals(PASSWORD)) {
                    if (++i >= args.length) {
                        ExtractImages.usage();
                    }
                    password = args[i];
                    continue;
                }
                if (args[i].equals(PREFIX)) {
                    if (++i >= args.length) {
                        ExtractImages.usage();
                    }
                    prefix = args[i];
                    continue;
                }
                if (pdfFile != null) continue;
                pdfFile = args[i];
            }
            if (pdfFile == null) {
                ExtractImages.usage();
            } else {
                if (prefix == null && pdfFile.length() > 4) {
                    prefix = pdfFile.substring(0, pdfFile.length() - 4);
                }
                try (PDDocument document = null;){
                    document = PDDocument.load(pdfFile);
                    if (document.isEncrypted()) {
                        StandardDecryptionMaterial spm = new StandardDecryptionMaterial(password);
                        document.openProtection(spm);
                        AccessPermission ap = document.getCurrentAccessPermission();
                        if (!ap.canExtractContent()) {
                            throw new IOException("Error: You do not have permission to extract images.");
                        }
                    }
                    List pages = document.getDocumentCatalog().getAllPages();
                    for (PDPage page : pages) {
                        PDResources resources = page.getResources();
                        Map images = resources.getImages();
                        if (images == null) continue;
                        for (String key : images.keySet()) {
                            PDXObjectImage image = (PDXObjectImage)images.get(key);
                            String name = this.getUniqueFileName(key, image.getSuffix());
                            System.out.println("Writing image:" + name);
                            image.write2file(name);
                        }
                    }
                }
            }
        }
    }

    private String getUniqueFileName(String prefix, String suffix) {
        String uniqueName = null;
        File f = null;
        while (f == null || f.exists()) {
            uniqueName = prefix + "-" + this.imageCounter;
            f = new File(uniqueName + "." + suffix);
            ++this.imageCounter;
        }
        return uniqueName;
    }

    private static void usage() {
        System.err.println("Usage: java org.pdfbox.ExtractImages [OPTIONS] <PDF file>\n  -password  <password>        Password to decrypt document\n  -prefix  <image-prefix>      Image prefix(default to pdf name)\n  <PDF file>                   The PDF document to use\n");
        System.exit(1);
    }
}

