/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox;

import org.pdfbox.pdmodel.PDDocument;

public class PrintPDF {
    private static final String PASSWORD = "-password";
    private static final String SILENT = "-silentPrint";

    private PrintPDF() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String password = "";
        String pdfFile = null;
        boolean silentPrint = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals(PASSWORD)) {
                if (++i >= args.length) {
                    PrintPDF.usage();
                }
                password = args[i];
                continue;
            }
            if (args[i].equals(SILENT)) {
                silentPrint = true;
                continue;
            }
            pdfFile = args[i];
        }
        if (pdfFile == null) {
            PrintPDF.usage();
        }
        try (PDDocument document = null;){
            document = PDDocument.load(pdfFile);
            if (document.isEncrypted()) {
                document.decrypt(password);
            }
            if (silentPrint) {
                document.silentPrint();
            } else {
                document.print();
            }
        }
    }

    private static void usage() {
        System.err.println("Usage: java org.pdfbox.PrintPDF [OPTIONS] <PDF file>\n  -password  <password>        Password to decrypt document\n  -silentPrint                 Print without prompting for printer info\n");
        System.exit(1);
    }
}

