/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.cos;

import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.cos.ICOSVisitor;
import org.pdfbox.exceptions.COSVisitorException;

public class COSFloat
extends COSNumber {
    private float value;

    public COSFloat(float aFloat) {
        this.value = aFloat;
    }

    public COSFloat(String aFloat) throws IOException {
        try {
            this.value = Float.parseFloat(aFloat);
        }
        catch (NumberFormatException e) {
            throw new IOException("Error expected floating point number actual='" + aFloat + "'");
        }
    }

    public void setValue(float floatValue) {
        this.value = floatValue;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    public boolean equals(Object o) {
        return o instanceof COSFloat && Float.floatToIntBits(((COSFloat)o).value) == Float.floatToIntBits(this.value);
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    public String toString() {
        return "COSFloat{" + this.value + "}";
    }

    @Override
    public Object accept(ICOSVisitor visitor) throws COSVisitorException {
        return visitor.visitFromFloat(this);
    }

    public void writePDF(OutputStream output) throws IOException {
        DecimalFormat formatDecimal = (DecimalFormat)NumberFormat.getNumberInstance();
        formatDecimal.setMaximumFractionDigits(10);
        formatDecimal.setGroupingUsed(false);
        DecimalFormatSymbols symbols = formatDecimal.getDecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        formatDecimal.setDecimalFormatSymbols(symbols);
        output.write(formatDecimal.format(this.value).getBytes());
    }
}

