/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.cos;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.ICOSVisitor;
import org.pdfbox.exceptions.COSVisitorException;
import org.pdfbox.persistence.util.COSHEXTable;

public final class COSName
extends COSBase
implements Comparable {
    private static Map nameMap = Collections.synchronizedMap(new HashMap(8192));
    public static final COSName A = new COSName("A");
    public static final COSName AA = new COSName("AA");
    public static final COSName ACRO_FORM = new COSName("AcroForm");
    public static final COSName ANNOTS = new COSName("Annots");
    public static final COSName ART_BOX = new COSName("ArtBox");
    public static final COSName ASCII85_DECODE = new COSName("ASCII85Decode");
    public static final COSName ASCII85_DECODE_ABBREVIATION = new COSName("A85");
    public static final COSName ASCII_HEX_DECODE = new COSName("ASCIIHexDecode");
    public static final COSName ASCII_HEX_DECODE_ABBREVIATION = new COSName("AHx");
    public static final COSName AP = new COSName("AP");
    public static final COSName B = new COSName("B");
    public static final COSName BASE_ENCODING = new COSName("BaseEncoding");
    public static final COSName BASE_FONT = new COSName("BaseFont");
    public static final COSName BBOX = new COSName("BBox");
    public static final COSName BLEED_BOX = new COSName("BleedBox");
    public static final COSName CATALOG = new COSName("Catalog");
    public static final COSName CALGRAY = new COSName("CalGray");
    public static final COSName CALRGB = new COSName("CalRGB");
    public static final COSName CCITTFAX_DECODE = new COSName("CCITTFaxDecode");
    public static final COSName CCITTFAX_DECODE_ABBREVIATION = new COSName("CCF");
    public static final COSName COLORSPACE = new COSName("ColorSpace");
    public static final COSName CONTENTS = new COSName("Contents");
    public static final COSName COUNT = new COSName("Count");
    public static final COSName CROP_BOX = new COSName("CropBox");
    public static final COSName DCT_DECODE = new COSName("DCTDecode");
    public static final COSName DCT_DECODE_ABBREVIATION = new COSName("DCT");
    public static final COSName DESCENDANT_FONTS = new COSName("DescendantFonts");
    public static final COSName DEST = new COSName("Dest");
    public static final COSName DEVICECMYK = new COSName("DeviceCMYK");
    public static final COSName DEVICEGRAY = new COSName("DeviceGray");
    public static final COSName DEVICEN = new COSName("DeviceN");
    public static final COSName DEVICERGB = new COSName("DeviceRGB");
    public static final COSName DIFFERENCES = new COSName("Differences");
    public static final COSName DV = new COSName("DV");
    public static final COSName ENCODING = new COSName("Encoding");
    public static final COSName ENCODING_90MS_RKSJ_H = new COSName("90ms-RKSJ-H");
    public static final COSName ENCODING_90MS_RKSJ_V = new COSName("90ms-RKSJ-V");
    public static final COSName ENCODING_ETEN_B5_H = new COSName("ETen?B5?H");
    public static final COSName ENCODING_ETEN_B5_V = new COSName("ETen?B5?V");
    public static final COSName FIELDS = new COSName("Fields");
    public static final COSName FILTER = new COSName("Filter");
    public static final COSName FIRST_CHAR = new COSName("FirstChar");
    public static final COSName FLATE_DECODE = new COSName("FlateDecode");
    public static final COSName FLATE_DECODE_ABBREVIATION = new COSName("Fl");
    public static final COSName FONT = new COSName("Font");
    public static final COSName FONT_FILE = new COSName("FontFile");
    public static final COSName FONT_FILE2 = new COSName("FontFile2");
    public static final COSName FONT_FILE3 = new COSName("FontFile3");
    public static final COSName FONT_DESC = new COSName("FontDescriptor");
    public static final COSName FONT_MATRIX = new COSName("FontMatrix");
    public static final COSName FORMTYPE = new COSName("FormType");
    public static final COSName FRM = new COSName("FRM");
    public static final COSName H = new COSName("H");
    public static final COSName HEIGHT = new COSName("Height");
    public static final COSName ICCBASED = new COSName("ICCBased");
    public static final COSName IDENTITY_H = new COSName("Identity-H");
    public static final COSName IMAGE = new COSName("Image");
    public static final COSName INDEXED = new COSName("Indexed");
    public static final COSName INFO = new COSName("Info");
    public static final COSName JPX_DECODE = new COSName("JPXDecode");
    public static final COSName KIDS = new COSName("Kids");
    public static final COSName LAB = new COSName("Lab");
    public static final COSName LAST_CHAR = new COSName("LastChar");
    public static final COSName LENGTH = new COSName("Length");
    public static final COSName LENGTH1 = new COSName("Length1");
    public static final COSName LZW_DECODE = new COSName("LZWDecode");
    public static final COSName LZW_DECODE_ABBREVIATION = new COSName("LZW");
    public static final COSName MAC_ROMAN_ENCODING = new COSName("MacRomanEncoding");
    public static final COSName MATRIX = new COSName("Matrix");
    public static final COSName MEDIA_BOX = new COSName("MediaBox");
    public static final COSName METADATA = new COSName("Metadata");
    public static final COSName N = new COSName("N");
    public static final COSName NAME = new COSName("Name");
    public static final COSName P = new COSName("P");
    public static final COSName PAGE = new COSName("Page");
    public static final COSName PAGES = new COSName("Pages");
    public static final COSName PARENT = new COSName("Parent");
    public static final COSName PATTERN = new COSName("Pattern");
    public static final COSName PDF_DOC_ENCODING = new COSName("PDFDocEncoding");
    public static final COSName PREV = new COSName("Prev");
    public static final COSName R = new COSName("R");
    public static final COSName RESOURCES = new COSName("Resources");
    public static final COSName ROOT = new COSName("Root");
    public static final COSName ROTATE = new COSName("Rotate");
    public static final COSName RUN_LENGTH_DECODE = new COSName("RunLengthDecode");
    public static final COSName RUN_LENGTH_DECODE_ABBREVIATION = new COSName("RL");
    public static final COSName SEPARATION = new COSName("Separation");
    public static final COSName STANDARD_ENCODING = new COSName("StandardEncoding");
    public static final COSName SUBTYPE = new COSName("Subtype");
    public static final COSName TRIM_BOX = new COSName("TrimBox");
    public static final COSName TRUE_TYPE = new COSName("TrueType");
    public static final COSName TO_UNICODE = new COSName("ToUnicode");
    public static final COSName TYPE = new COSName("Type");
    public static final COSName TYPE0 = new COSName("Type0");
    public static final COSName V = new COSName("V");
    public static final COSName VERSION = new COSName("Version");
    public static final COSName WIDTHS = new COSName("Widths");
    public static final COSName WIN_ANSI_ENCODING = new COSName("WinAnsiEncoding");
    public static final COSName XOBJECT = new COSName("XObject");
    public static final byte[] NAME_PREFIX = new byte[]{47};
    public static final byte[] NAME_ESCAPE = new byte[]{35};
    private String name;
    private int hashCode;

    public static final COSName getPDFName(String aName) {
        COSName name = null;
        if (aName != null && (name = (COSName)nameMap.get(aName)) == null) {
            name = new COSName(aName);
        }
        return name;
    }

    private COSName(String aName) {
        this.name = aName;
        nameMap.put(aName, this);
        this.hashCode = this.name.hashCode();
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "COSName{" + this.name + "}";
    }

    public boolean equals(Object o) {
        boolean retval;
        boolean bl = retval = this == o;
        if (!retval && o instanceof COSName) {
            COSName other = (COSName)o;
            retval = this.name == other.name || this.name.equals(other.name);
        }
        return retval;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public int compareTo(Object o) {
        COSName other = (COSName)o;
        return this.name.compareTo(other.name);
    }

    @Override
    public Object accept(ICOSVisitor visitor) throws COSVisitorException {
        return visitor.visitFromName(this);
    }

    public void writePDF(OutputStream output) throws IOException {
        output.write(NAME_PREFIX);
        byte[] bytes = this.getName().getBytes();
        for (int i = 0; i < bytes.length; ++i) {
            int current = (bytes[i] + 256) % 256;
            if (current <= 32 || current >= 127 || current == 40 || current == 41 || current == 91 || current == 93 || current == 47 || current == 37 || current == 60 || current == 62 || current == NAME_ESCAPE[0]) {
                output.write(NAME_ESCAPE);
                output.write(COSHEXTable.TABLE[current]);
                continue;
            }
            output.write(current);
        }
    }
}

