/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.cos;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.ICOSVisitor;
import org.pdfbox.exceptions.COSVisitorException;
import org.pdfbox.persistence.util.COSHEXTable;

public class COSString
extends COSBase {
    public static final byte[] STRING_OPEN = new byte[]{40};
    public static final byte[] STRING_CLOSE = new byte[]{41};
    public static final byte[] HEX_STRING_OPEN = new byte[]{60};
    public static final byte[] HEX_STRING_CLOSE = new byte[]{62};
    public static final byte[] ESCAPE = new byte[]{92};
    public static final byte[] CR_ESCAPE = new byte[]{92, 114};
    public static final byte[] LF_ESCAPE = new byte[]{92, 110};
    public static final byte[] HT_ESCAPE = new byte[]{92, 116};
    public static final byte[] BS_ESCAPE = new byte[]{92, 98};
    public static final byte[] FF_ESCAPE = new byte[]{92, 102};
    private ByteArrayOutputStream out = new ByteArrayOutputStream();
    private boolean forceLiteralForm = false;

    public COSString() {
    }

    public COSString(String value) {
        try {
            boolean unicode16 = false;
            char[] chars = value.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (chars[i] <= '\u00ff') continue;
                unicode16 = true;
            }
            if (unicode16) {
                this.out.write(254);
                this.out.write(255);
                this.out.write(value.getBytes("UTF-16BE"));
            } else {
                this.out.write(value.getBytes("ISO-8859-1"));
            }
        }
        catch (IOException ignore) {
            ignore.printStackTrace();
        }
    }

    public COSString(byte[] value) {
        try {
            this.out.write(value);
        }
        catch (IOException ignore) {
            ignore.printStackTrace();
        }
    }

    public void setForceLiteralForm(boolean v) {
        this.forceLiteralForm = v;
    }

    public static COSString createFromHexString(String hex) throws IOException {
        COSString retval = new COSString();
        StringBuffer hexBuffer = new StringBuffer(hex.trim());
        if (hexBuffer.length() % 2 == 1) {
            hexBuffer.append("0");
        }
        int i = 0;
        while (i < hexBuffer.length()) {
            String hexChars = "" + hexBuffer.charAt(i++) + hexBuffer.charAt(i++);
            try {
                retval.append(Integer.parseInt(hexChars, 16));
            }
            catch (NumberFormatException e) {
                throw new IOException("Error: Expected hex number, actual='" + hexChars + "'");
            }
        }
        return retval;
    }

    public String getHexString() {
        StringBuffer retval = new StringBuffer(this.out.size() * 2);
        byte[] data = this.getBytes();
        for (int i = 0; i < data.length; ++i) {
            retval.append(COSHEXTable.HEX_TABLE[(data[i] + 256) % 256]);
        }
        return retval.toString();
    }

    public String getString() {
        String retval;
        String encoding = "ISO-8859-1";
        byte[] data = this.getBytes();
        int start = 0;
        if (data.length > 2) {
            if (data[0] == -1 && data[1] == -2) {
                encoding = "UTF-16LE";
                start = 2;
            } else if (data[0] == -2 && data[1] == -1) {
                encoding = "UTF-16BE";
                start = 2;
            }
        }
        try {
            retval = new String(this.getBytes(), start, data.length - start, encoding);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            retval = new String(this.getBytes());
        }
        return retval;
    }

    public void append(byte[] data) throws IOException {
        this.out.write(data);
    }

    public void append(int in) throws IOException {
        this.out.write(in);
    }

    public void reset() {
        this.out.reset();
    }

    public byte[] getBytes() {
        return this.out.toByteArray();
    }

    public String toString() {
        return "COSString{" + new String(this.getBytes()) + "}";
    }

    public void writePDF(OutputStream output) throws IOException {
        int i;
        boolean outsideASCII = false;
        byte[] bytes = this.getBytes();
        for (i = 0; i < bytes.length && !outsideASCII; ++i) {
            outsideASCII = bytes[i] < 0;
        }
        if (!outsideASCII || this.forceLiteralForm) {
            output.write(STRING_OPEN);
            block9: for (i = 0; i < bytes.length; ++i) {
                int b = (bytes[i] + 256) % 256;
                switch (b) {
                    case 40: 
                    case 41: 
                    case 92: {
                        output.write(ESCAPE);
                        output.write(b);
                        continue block9;
                    }
                    case 10: {
                        output.write(LF_ESCAPE);
                        continue block9;
                    }
                    case 13: {
                        output.write(CR_ESCAPE);
                        continue block9;
                    }
                    case 9: {
                        output.write(HT_ESCAPE);
                        continue block9;
                    }
                    case 8: {
                        output.write(BS_ESCAPE);
                        continue block9;
                    }
                    case 12: {
                        output.write(FF_ESCAPE);
                        continue block9;
                    }
                    default: {
                        output.write(b);
                    }
                }
            }
            output.write(STRING_CLOSE);
        } else {
            output.write(HEX_STRING_OPEN);
            for (i = 0; i < bytes.length; ++i) {
                output.write(COSHEXTable.TABLE[(bytes[i] + 256) % 256]);
            }
            output.write(HEX_STRING_CLOSE);
        }
    }

    @Override
    public Object accept(ICOSVisitor visitor) throws COSVisitorException {
        return visitor.visitFromString(this);
    }

    public boolean equals(Object obj) {
        return obj instanceof COSString && Arrays.equals(((COSString)obj).getBytes(), this.getBytes());
    }

    public int hashCode() {
        return this.getBytes().hashCode();
    }
}

