/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.examples.fdf;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.pdfbox.exceptions.CryptographyException;
import org.pdfbox.exceptions.InvalidPasswordException;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDDocumentCatalog;
import org.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.pdfbox.pdmodel.interactive.form.PDField;

public class PrintFields {
    public void printFields(PDDocument pdfDocument) throws IOException {
        PDDocumentCatalog docCatalog = pdfDocument.getDocumentCatalog();
        PDAcroForm acroForm = docCatalog.getAcroForm();
        List fields = acroForm.getFields();
        Iterator fieldsIter = fields.iterator();
        System.out.println(new Integer(fields.size()).toString() + " top-level fields were found on the form");
        while (fieldsIter.hasNext()) {
            PDField field = (PDField)fieldsIter.next();
            this.processField(field, "|--", field.getPartialName());
        }
    }

    private void processField(PDField field, String sLevel, String sParent) throws IOException {
        List kids = field.getKids();
        if (kids != null) {
            Iterator kidsIter = kids.iterator();
            if (!sParent.equals(field.getPartialName())) {
                sParent = sParent + "." + field.getPartialName();
            }
            System.out.println(sLevel + sParent);
            while (kidsIter.hasNext()) {
                Object pdfObj = kidsIter.next();
                if (!(pdfObj instanceof PDField)) continue;
                PDField kid = (PDField)pdfObj;
                this.processField(kid, "|  " + sLevel, sParent);
            }
        } else {
            String outputString = sLevel + sParent + "." + field.getPartialName() + " = " + field.getValue() + ",  type=" + field.getClass().getName();
            System.out.println(outputString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, CryptographyException {
        block8: {
            try (PDDocument pdf = null;){
                if (args.length != 1) {
                    PrintFields.usage();
                    break block8;
                }
                pdf = PDDocument.load(args[0]);
                PrintFields exporter = new PrintFields();
                if (pdf.isEncrypted()) {
                    try {
                        pdf.decrypt("");
                    }
                    catch (InvalidPasswordException e) {
                        System.err.println("Error: The document is encrypted.");
                        PrintFields.usage();
                    }
                }
                exporter.printFields(pdf);
            }
        }
    }

    private static void usage() {
        System.err.println("usage: org.pdfbox.examples.fdf.PrintFields <pdf-file>");
    }
}

