/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.examples.pdmodel;

import java.io.IOException;
import java.util.List;
import org.pdfbox.exceptions.COSVisitorException;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.common.PDRectangle;
import org.pdfbox.pdmodel.edit.PDPageContentStream;
import org.pdfbox.pdmodel.font.PDType1Font;

public class AddMessageToEachPage {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIt(String file, String message, String outfile) throws IOException, COSVisitorException {
        try (PDDocument doc = null;){
            doc = PDDocument.load(file);
            List allPages = doc.getDocumentCatalog().getAllPages();
            PDType1Font font = PDType1Font.HELVETICA_BOLD;
            float fontSize = 12.0f;
            for (int i = 0; i < allPages.size(); ++i) {
                PDPage page = (PDPage)allPages.get(i);
                PDRectangle pageSize = page.findMediaBox();
                float stringWidth = font.getStringWidth(message);
                float centeredPosition = (pageSize.getWidth() - stringWidth * fontSize / 1000.0f) / 2.0f;
                PDPageContentStream contentStream = new PDPageContentStream(doc, page, true, true);
                contentStream.beginText();
                contentStream.setFont(font, fontSize);
                contentStream.moveTextPositionByAmount(centeredPosition, 30.0f);
                contentStream.drawString(message);
                contentStream.endText();
                contentStream.close();
            }
            doc.save(outfile);
        }
    }

    public static void main(String[] args) {
        AddMessageToEachPage app = new AddMessageToEachPage();
        try {
            if (args.length != 3) {
                app.usage();
            } else {
                app.doIt(args[0], args[1], args[2]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void usage() {
        System.err.println("usage: " + this.getClass().getName() + " <input-file> <Message> <output-file>");
    }
}

