/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.examples.pdmodel;

import java.io.IOException;
import java.util.List;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.interactive.action.type.PDActionGoTo;
import org.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;

public class GoToSecondBookmarkOnOpen {
    private GoToSecondBookmarkOnOpen() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            GoToSecondBookmarkOnOpen.usage();
        } else {
            try (PDDocument document = null;){
                List pages;
                document = PDDocument.load(args[0]);
                if (document.isEncrypted()) {
                    System.err.println("Error: Cannot add bookmark destination to encrypted documents.");
                    System.exit(1);
                }
                if ((pages = document.getDocumentCatalog().getAllPages()).size() < 2) {
                    throw new IOException("Error: The PDF must have at least 2 pages.");
                }
                PDDocumentOutline bookmarks = document.getDocumentCatalog().getDocumentOutline();
                if (bookmarks == null) {
                    throw new IOException("Error: The PDF does not contain any bookmarks");
                }
                PDOutlineItem item = bookmarks.getFirstChild().getNextSibling();
                PDDestination dest = item.getDestination();
                PDActionGoTo action = new PDActionGoTo();
                action.setDestination(dest);
                document.getDocumentCatalog().setOpenAction(action);
                document.save(args[1]);
            }
        }
    }

    private static void usage() {
        System.err.println("Usage: java org.pdfbox.examples.pdmodel.CreateBookmarks <input-pdf> <output-pdf>");
    }
}

