/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.examples.pdmodel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.pdfbox.exceptions.COSVisitorException;
import org.pdfbox.io.RandomAccessFile;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.edit.PDPageContentStream;
import org.pdfbox.pdmodel.graphics.xobject.PDCcitt;
import org.pdfbox.pdmodel.graphics.xobject.PDJpeg;
import org.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;

public class ImageToPDF {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPDFFromImage(String file, String image) throws IOException, COSVisitorException {
        try (PDDocument doc = null;){
            doc = new PDDocument();
            PDPage page = new PDPage();
            doc.addPage(page);
            PDXObjectImage ximage = null;
            if (image.toLowerCase().endsWith(".jpg")) {
                ximage = new PDJpeg(doc, new FileInputStream(image));
            } else if (image.toLowerCase().endsWith(".tif") || image.toLowerCase().endsWith(".tiff")) {
                ximage = new PDCcitt(doc, new RandomAccessFile(new File(image), "r"));
            } else {
                throw new IOException("Image type not supported:" + image);
            }
            PDPageContentStream contentStream = new PDPageContentStream(doc, page);
            contentStream.drawImage(ximage, 20.0f, 20.0f);
            contentStream.close();
            doc.save(file);
        }
    }

    public static void main(String[] args) {
        ImageToPDF app = new ImageToPDF();
        try {
            if (args.length != 2) {
                app.usage();
            } else {
                app.createPDFFromImage(args[0], args[1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void usage() {
        System.err.println("usage: " + this.getClass().getName() + " <output-file> <image>");
    }
}

