/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.examples.pdmodel;

import java.io.IOException;
import org.pdfbox.pdmodel.PDDocument;

public class RemoveFirstPage {
    private RemoveFirstPage() {
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            RemoveFirstPage.usage();
        } else {
            try (PDDocument document = null;){
                document = PDDocument.load(args[0]);
                if (document.isEncrypted()) {
                    throw new IOException("Encrypted documents are not supported for this example");
                }
                if (document.getNumberOfPages() <= 1) {
                    throw new IOException("Error: A PDF document must have at least one page, cannot remove the last page!");
                }
                document.removePage(0);
                document.save(args[1]);
            }
        }
    }

    private static void usage() {
        System.err.println("Usage: java org.pdfbox.examples.pdmodel.RemoveFirstPage <input-pdf> <output-pdf>");
    }
}

