/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.filter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.filter.Filter;
import org.pdfbox.persistence.util.COSHEXTable;

public class ASCIIHexFilter
implements Filter {
    private static final int[] REVERSE_HEX = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15};

    @Override
    public void decode(InputStream compressedData, OutputStream result, COSDictionary options) throws IOException {
        int value = 0;
        int firstByte = 0;
        int secondByte = 0;
        while ((firstByte = compressedData.read()) != -1) {
            value = REVERSE_HEX[firstByte] * 16;
            secondByte = compressedData.read();
            if (secondByte >= 0) {
                value += REVERSE_HEX[secondByte];
            }
            result.write(value);
        }
        result.flush();
    }

    @Override
    public void encode(InputStream rawData, OutputStream result, COSDictionary options) throws IOException {
        int byteRead = 0;
        while ((byteRead = rawData.read()) != -1) {
            int value = (byteRead + 256) % 256;
            result.write(COSHEXTable.TABLE[value]);
        }
        result.flush();
    }
}

