/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.filter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.filter.Filter;

public class FlateFilter
implements Filter {
    private static final int BUFFER_SIZE = 2048;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decode(InputStream compressedData, OutputStream result, COSDictionary options) throws IOException {
        COSDictionary dict = (COSDictionary)options.getDictionaryObject("DecodeParms");
        int predictor = -1;
        int colors = -1;
        int bitsPerPixel = -1;
        int columns = -1;
        InflaterInputStream decompressor = null;
        ByteArrayInputStream bais = null;
        ByteArrayOutputStream baos = null;
        if (dict != null) {
            predictor = dict.getInt("Predictor");
            colors = dict.getInt("Colors");
            bitsPerPixel = options.getInt("BitsPerComponent");
            columns = dict.getInt("Columns");
        }
        try {
            decompressor = new InflaterInputStream(compressedData);
            byte[] buffer = new byte[2048];
            if (predictor == -1 || predictor == 1 || predictor == 10) {
                int amountRead;
                while ((amountRead = decompressor.read(buffer, 0, 2048)) != -1) {
                    result.write(buffer, 0, amountRead);
                }
            } else {
                int amountRead;
                if (colors == -1 || bitsPerPixel == -1 || columns == -1) {
                    throw new IOException("Could not read all parameters to decode image");
                }
                baos = new ByteArrayOutputStream();
                while ((amountRead = decompressor.read(buffer, 0, 2048)) != -1) {
                    baos.write(buffer, 0, amountRead);
                }
                baos.flush();
                bais = new ByteArrayInputStream(baos.toByteArray());
                baos.close();
                baos = null;
                byte[] decodedData = this.decodePredictor(predictor, colors, bitsPerPixel, columns, bais);
                bais.close();
                bais = new ByteArrayInputStream(decodedData);
                while ((amountRead = bais.read(buffer)) != -1) {
                    result.write(buffer, 0, amountRead);
                }
                bais.close();
                bais = null;
            }
            result.flush();
        }
        finally {
            if (decompressor != null) {
                decompressor.close();
            }
            if (bais != null) {
                bais.close();
            }
            if (baos != null) {
                baos.close();
            }
        }
    }

    private byte[] decodePredictor(int predictor, int colors, int bitsPerComponent, int columns, InputStream data) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[2048];
        if (predictor == 1 || predictor == 10) {
            int i = 0;
            while ((i = data.read(buffer)) != -1) {
                baos.write(buffer, 0, i);
            }
        } else {
            int bpp = (colors * bitsPerComponent + 7) / 8;
            int rowlength = (columns * colors * bitsPerComponent + 7) / 8 + bpp;
            byte[] actline = new byte[rowlength];
            byte[] lastline = new byte[rowlength];
            boolean done = false;
            int linepredictor = predictor;
            while (!done) {
                if (predictor == 15) {
                    linepredictor = data.read();
                    if (linepredictor == -1) {
                        done = true;
                        break;
                    }
                    linepredictor += 10;
                }
                int i = 0;
                for (int offset = bpp; offset < rowlength && (i = data.read(actline, offset, rowlength - offset)) != -1; offset += i) {
                }
                switch (linepredictor) {
                    case 2: {
                        throw new IOException("TIFF-Predictor not supported");
                    }
                    case 11: {
                        int left;
                        int p;
                        for (p = bpp; p < rowlength; ++p) {
                            int sub = actline[p] & 0xFF;
                            left = actline[p - bpp] & 0xFF;
                            actline[p] = (byte)(sub + left);
                        }
                        break;
                    }
                    case 12: {
                        int p;
                        for (p = bpp; p < rowlength; ++p) {
                            int up = actline[p] & 0xFF;
                            int prior = lastline[p] & 0xFF;
                            actline[p] = (byte)(up + prior);
                        }
                        break;
                    }
                    case 13: {
                        int left;
                        int p;
                        for (p = bpp; p < rowlength; ++p) {
                            int avg = actline[p] & 0xFF;
                            left = actline[p - bpp] & 0xFF;
                            int up = lastline[p] & 0xFF;
                            actline[p] = (byte)(avg + (left + up) / 2);
                        }
                        break;
                    }
                    case 14: {
                        int p;
                        for (p = bpp; p < rowlength; ++p) {
                            int paeth = actline[p] & 0xFF;
                            int a = actline[p - bpp] & 0xFF;
                            int b = lastline[p] & 0xFF;
                            int c = lastline[p - bpp] & 0xFF;
                            int value = a + b - c;
                            int absa = Math.abs(value - a);
                            int absb = Math.abs(value - b);
                            int absc = Math.abs(value - c);
                            if (absa <= absb && absa <= absc) {
                                actline[p] = (byte)(paeth + absa);
                                continue;
                            }
                            if (absb <= absc) {
                                int n = p;
                                actline[n] = (byte)(actline[n] + (byte)(paeth + absb));
                                continue;
                            }
                            int n = p;
                            actline[n] = (byte)(actline[n] + (byte)(paeth + absc));
                        }
                        break;
                    }
                }
                lastline = actline;
                baos.write(actline, bpp, actline.length - bpp);
            }
        }
        return baos.toByteArray();
    }

    @Override
    public void encode(InputStream rawData, OutputStream result, COSDictionary options) throws IOException {
        DeflaterOutputStream out = new DeflaterOutputStream(result);
        byte[] buffer = new byte[2048];
        int amountRead = 0;
        while ((amountRead = rawData.read(buffer, 0, 2048)) != -1) {
            out.write(buffer, 0, amountRead);
        }
        out.close();
        result.flush();
    }
}

